/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.latex;

import com.teamscale.service.audit.EAuditExportLanguage;
import com.teamscale.service.audit.EAuditMessageKey;
import com.teamscale.service.audit.latex.ProjectDataAccessor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

public abstract class LatexTableCreatorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TABLE_HEADER = "\\begin{table} \n\\setlength{\\tabcolsep}{5pt} \n\\centering \n";
    private static final String TABLE_FOOTER = "\\end{tabular} \n\\caption{cap:caption} \n\\label{tab:label} \n\\end{table} \n";
    public static final String LATEX_END_OF_LINE = " \\\\ \n";
    private final EAuditExportLanguage language;
    protected ProjectDataAccessor[] projectDataAcessors;
    protected ProjectDataAccessor mainProjectAccessor;

    protected LatexTableCreatorBase(EAuditExportLanguage language, ProjectDataAccessor mainProjectAccessor, ProjectDataAccessor ... subProjectDataAccessors) {
        this.language = language;
        this.initializeProjectDataAccessors(mainProjectAccessor, subProjectDataAccessors);
    }

    private void initializeProjectDataAccessors(ProjectDataAccessor mainProjectAccessor, ProjectDataAccessor ... subProjectDataAccessors) {
        this.mainProjectAccessor = mainProjectAccessor;
        this.projectDataAcessors = new ProjectDataAccessor[subProjectDataAccessors.length + 1];
        System.arraycopy(subProjectDataAccessors, 0, this.projectDataAcessors, 0, subProjectDataAccessors.length);
        this.projectDataAcessors[subProjectDataAccessors.length] = mainProjectAccessor;
    }

    protected String getMessage(EAuditMessageKey messageKey) {
        return this.language.getMessage(messageKey);
    }

    protected static void logMetricDisabledWarning(ProjectDataAccessor accessor, String metricName) {
        LOGGER.warn("The metric '" + metricName + "' is not enabled for the project '" + String.valueOf(accessor.getProjectId()) + "'.");
    }

    protected String getMetricHeader() {
        return "\\ctextbf{" + this.getMessage(EAuditMessageKey.METRIC_HEADER) + "}";
    }

    public String createTable() throws StorageException {
        StringBuilder builder = new StringBuilder();
        builder.append(TABLE_HEADER).append(this.getColumnDefinition());
        if (this.shouldPrintTableColumns()) {
            builder.append(this.getTableColumns());
        }
        builder.append(this.getTableContent()).append(this.getTableFooter());
        return builder.toString();
    }

    protected boolean shouldPrintTableColumns() {
        return true;
    }

    protected abstract String getColumnDefinition();

    protected abstract String getTableColumns();

    protected abstract String getTableContent() throws StorageException;

    private String getTableFooter() {
        return TABLE_FOOTER.replace("tab:label", this.getLabel()).replace("cap:caption", this.getName());
    }

    protected abstract String getLabel();

    protected abstract String getName();

    protected String getPercentageFromDouble(double value) {
        if (Double.isNaN(value)) {
            return "-";
        }
        DecimalFormat twoDecimals = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(this.language.getLocale()));
        return twoDecimals.format(value * 100.0);
    }

    protected String formatDouble(double value) {
        if (Double.isNaN(value)) {
            return "-";
        }
        DecimalFormat format = new DecimalFormat("#,###.#", DecimalFormatSymbols.getInstance(this.language.getLocale()));
        return format.format(value);
    }

    protected static String formatDoubleForInCellAssessment(double value) {
        if (Double.isNaN(value)) {
            return "-";
        }
        DecimalFormat format = new DecimalFormat("###.###", DecimalFormatSymbols.getInstance(Locale.US));
        return format.format(value);
    }

    protected static String createTableRow(String label, String ... values) {
        StringBuilder builder = new StringBuilder(label);
        for (String value : values) {
            builder.append(" & ").append(value);
        }
        builder.append(LATEX_END_OF_LINE);
        return builder.toString();
    }
}

