/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.base;

import com.teamscale.service.PaginationOptions;
import com.teamscale.service.base.ESortOrder;
import com.teamscale.service.base.SortOptions;
import jakarta.ws.rs.BeanParam;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class SortAndPaginationOptions {
    @BeanParam
    private PaginationOptions paginationOptions;
    @BeanParam
    private SortOptions sortOptions;

    public SortAndPaginationOptions() {
    }

    public SortAndPaginationOptions(int startIndex, int maxResults, String sortBy, ESortOrder sortOrder) {
        this.paginationOptions = new PaginationOptions(startIndex, maxResults);
        this.sortOptions = new SortOptions(sortBy, sortOrder);
    }

    public <T> List<T> sortAndPaginate(List<T> results, Function<String, Comparator<T>> fieldComparatorFactory) {
        List<T> sorted = this.sortOptions.sort(results, fieldComparatorFactory);
        return this.paginationOptions.applyFilter(sorted);
    }

    public int getNextStartIndex() {
        return this.paginationOptions.getStartIndex() + this.paginationOptions.getMaxResults();
    }

    public SortOptions getSortOptions() {
        return this.sortOptions;
    }
}

