/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard.widgets;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.user.User;
import com.teamscale.index.code_ownership.CodeOwnershipData;
import com.teamscale.index.code_ownership.CodeOwnershipIndex;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.metrics.treemap.builder.NumericValueTreeMapBuilderBase;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class CodeOwnershipTreemapBuilder
extends NumericValueTreeMapBuilderBase<Integer, TreeMapNode> {
    private final UserAliasLookup userAliasLookup;
    private final MetricsToArchitectureMetricsMappingIndex mappingIndex;
    private final long baselineTimestamp;
    private final CodeOwnershipIndex ownershipIndex;
    private final boolean excludeMergeCommits;
    private final boolean excludeImportCommits;

    protected CodeOwnershipTreemapBuilder(Pattern includePattern, Pattern excludePattern, IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, Object colorMetricDefault, Color baseColor, CodeOwnershipIndex ownershipIndex, boolean excludeMergeCommits, boolean excludeImportCommits, UserAliasLookup userAliasLookup, MetricsToArchitectureMetricsMappingIndex mappingIndex, long baselineTimestamp) {
        super(includePattern, excludePattern, metricRetrievalStrategy, historyAccessOption, areaMetricIndex, colorMetricDefault, baseColor, false);
        this.ownershipIndex = ownershipIndex;
        this.excludeMergeCommits = excludeMergeCommits;
        this.excludeImportCommits = excludeImportCommits;
        this.userAliasLookup = userAliasLookup;
        this.mappingIndex = mappingIndex;
        this.baselineTimestamp = baselineTimestamp;
    }

    @Override
    protected Map<String, Integer> calculateValues(String pathPrefix) throws StorageException {
        PairList ownershipEntries = ArchitectureMetricsUtils.isArchitectureArtifactPath((String)pathPrefix) ? this.loadCodeOwnershipDataForArchitecturePath(pathPrefix) : this.ownershipIndex.getCodeOwnershipData(pathPrefix);
        ownershipEntries.forEach((uniformPath, ownershipData) -> ownershipData.removeAuthorsCommittedBefore(this.baselineTimestamp));
        HashMap<String, CodeOwnershipData> ownershipDataMap = new HashMap<String, CodeOwnershipData>();
        ownershipEntries.forEach((uniformPath, ownershipData) -> {
            ownershipData.removeAuthorsCommittedBefore(this.baselineTimestamp);
            String path = uniformPath;
            while (!StringUtils.isEmpty((String)path) && path.startsWith(StringUtils.stripSuffix((String)pathPrefix, (String)UniformPathUtils.SEPARATOR))) {
                ownershipDataMap.merge(path, (CodeOwnershipData)ownershipData, CodeOwnershipData::merge);
                path = UniformPathUtils.getParentPath((String)path);
            }
        });
        CounterSet result = new CounterSet();
        ownershipDataMap.forEach((uniformPath, ownershipData) -> result.inc(uniformPath, this.getUsernames((CodeOwnershipData)ownershipData, this.userAliasLookup).size()));
        return result.toMap();
    }

    private PairList<String, CodeOwnershipData> loadCodeOwnershipDataForArchitecturePath(String architecturePath) throws StorageException {
        Map pathToArchitecturePath = ArchitectureMetricsUtils.getRecursivePathMappings((MetricsToArchitectureMetricsMappingIndex)this.mappingIndex, (String)architecturePath);
        ArrayList paths = new ArrayList(pathToArchitecturePath.keySet());
        List codeOwnerShipData = this.ownershipIndex.getCodeOwnershipData(paths);
        PairList ownershipEntries = new PairList(paths.size());
        for (int i = 0; i < paths.size(); ++i) {
            ownershipEntries.add((Object)((String)pathToArchitecturePath.get(paths.get(i))), (Object)((CodeOwnershipData)codeOwnerShipData.get(i)));
        }
        return ownershipEntries;
    }

    private Set<String> getUsernames(CodeOwnershipData ownershipData, UserAliasLookup userAliasLookup) {
        Set authors = this.excludeMergeCommits ? ownershipData.getCommitters() : ownershipData.getCommittersAndMergers();
        if (this.excludeImportCommits) {
            authors.remove("Teamscale import");
        }
        HashSet<String> resolvedUsers = new HashSet<String>();
        authors.forEach(author -> resolvedUsers.add(userAliasLookup.resolveUser(author).map(User::getUsername).orElse((String)author)));
        return resolvedUsers;
    }

    @Override
    protected String formatMetricValue(Object value) {
        double doubleValue = Double.parseDouble(value.toString());
        int intValue = (int)doubleValue;
        return String.valueOf(intValue);
    }

    @Override
    protected TreeMapNode createNode(MetricDirectoryEntry entry) throws StorageException {
        return new TreeMapNode(entry.getUniformPath(), entry.getDoubleValue(this.areaMetricIndex), this.formatMetricValue(entry.getValueOrDefault(this.builderParameters.colorMetricIndex, this.builderParameters.colorMetricDefault)), this.determineColor(entry));
    }
}

