/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dependencies.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.dependencies.DependencyListIndex;
import com.teamscale.service.architecture.dependency.DependencyServiceBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/dependencies/debug/dump")
public class DebugDependencyListDumpService
extends DependencyServiceBase {
    @GET
    @Operation(summary="Get a dependency dump for debugging.", description="Returns all dependencies from the dependency index formatted as string.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String getDependencyListDump(@QueryParam(value="t") @Parameter(required=true) UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        DependencyListIndex dependencyListIndex = this.openProjectIndex(DependencyListIndex.class, "dependencies", historyAccessOption);
        PairList allDependencies = dependencyListIndex.getAllDependencies();
        StringBuilder result = new StringBuilder();
        for (Pair dependency : allDependencies) {
            ArrayList affectedFiles = (ArrayList)dependency.getSecond();
            if (affectedFiles.isEmpty()) continue;
            result.append((String)dependency.getFirst() + ":\n");
            for (String value : affectedFiles) {
                result.append(" - ").append(value).append("\n");
            }
        }
        return result.toString();
    }
}

