/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.metrics.source.IndexMetricSource;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.project.MetricSchemaChangeEntry;
import com.teamscale.service.metrics.schema.GlobalMetricSchemaService;
import eu.cqse.check.framework.scanner.ELanguage;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.InternalServerErrorException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ExternalMetricsServiceUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void warnIfMetricSchemaEntryIdAlreadyInUse(List<MetricSchemaChangeEntry> schemaEntries, GlobalStorageSystem globalStorageSystem) throws StorageException, BadRequestException {
        for (String metricId : ExternalMetricsServiceUtils.findExistingMetricSchemaEntriesWithGivenIds(schemaEntries, globalStorageSystem)) {
            LOGGER.warn("The given metric ID '" + metricId + "' is already in use. Metric IDs can only be used once.");
        }
    }

    public static void validateIdentifiersInMetricSchemaEntries(List<MetricSchemaChangeEntry> schemaEntries) {
        for (MetricSchemaChangeEntry entry : schemaEntries) {
            Optional errorMessage = entry.validateIdentifiers();
            if (!errorMessage.isPresent()) continue;
            throw new BadRequestException("Invalid external metric entry. " + (String)errorMessage.get());
        }
    }

    private static Set<String> findExistingMetricSchemaEntriesWithGivenIds(List<MetricSchemaChangeEntry> schemaEntries, GlobalStorageSystem globalStorageSystem) throws StorageException {
        HashSet newMetricIds = new HashSet(CollectionUtils.map(schemaEntries, MetricSchemaChangeEntry::getMetricId));
        try {
            Set externalTools = EAnalysisTool.getAlwaysAvailableTools();
            EnumSet<ELanguage> allLanguages = EnumSet.allOf(ELanguage.class);
            AnalysisProfile analysisProfile = new AnalysisProfile("dummy", allLanguages, externalTools);
            ConfigurationTemplate configurationTemplate = ConfigRegistry.getInstance().createConfigurationTemplate(allLanguages, externalTools, globalStorageSystem);
            AnalysisProfileUtils.createQualityIndicators((AnalysisProfile)analysisProfile, (ConfigurationTemplate)configurationTemplate);
            AnalysisProfileUtils.createGlobalOptions((AnalysisProfile)analysisProfile, (ConfigurationTemplate)configurationTemplate);
            ProjectStorageSystem projectPartition = GlobalMetricSchemaService.createDummyProject(analysisProfile, globalStorageSystem);
            MetricSchemaIndex metricSchemaIndex = (MetricSchemaIndex)projectPartition.openProjectIndex(MetricSchemaIndex.class, "metric-schema", HistoryAccessOption.readHeadUnbranched());
            return metricSchemaIndex.getMetricSources().stream().filter(s -> s instanceof IndexMetricSource).map(s -> ((IndexMetricSource)s).getMetricPartition()).filter(newMetricIds::contains).collect(Collectors.toSet());
        }
        catch (ProjectConfigurationException | TriggerCompilationException | IOException e) {
            throw new InternalServerErrorException("Internal error when checking if the given metric id is already in use: " + e.getMessage(), e);
        }
    }
}

