/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.git.debug;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.debug.DebugDumperRegistry;
import com.teamscale.core.debug.EDebugDumpEvent;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.git.GitMainRepository;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.labeling.GitDebugInformation;
import com.teamscale.index.repository.git.labeling.PathBuildingBranchLabeler;
import com.teamscale.index.repository.git.labeling.TestCommitGraphNode;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.repository.GitRepositoryConnectorUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.revwalk.RevCommit;

@Path(value="api/projects/{project}/git/debug/information")
public class DebugGitInformationDumpService
extends ApiBase {
    private static final Set<String> GIT_CONNECTOR_NAMES = Arrays.stream(ERepositoryConnector.values()).filter(ERepositoryConnector::isGitBasedConnector).map(ERepositoryConnector::getReadableName).collect(Collectors.toSet());
    private String repositoryId;

    @GET
    @Path(value="{repositoryId}")
    @Operation(summary="Get git information", description="Returns all git repository information regarding one connector for debugging labeling problems easily.", tags={"Debugging"}, responses={@ApiResponse(responseCode="400", description="The given connector is not a valid connector.")})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"application/json"})
    public byte[] getGitInformation(@Parameter(description="The id of the repository") @PathParam(value="repositoryId") String repoId) throws StorageException {
        this.repositoryId = repoId;
        try {
            GitRepositoryInfoIndex gitInfoIndex = this.openGitInfoIndex();
            GitRepositoryConnector connector = this.buildRepositoryConnector(gitInfoIndex);
            GitRepositoryConnection connection = GitRepositoryConnectorUtils.createGitRepositoryConnection(connector, this.getIndexLayer());
            GitMainRepository repository = connection.getMainRepository();
            ArrayList<TestCommitGraphNode> sortedCommits = this.getCommitsFromRepository(connection, repository);
            PathBuildingBranchLabeler labeler = DebugGitInformationDumpService.getPathBuildingBranchLabeler(gitInfoIndex, connection, repository);
            GitDebugInformation debugInformation = DebugGitInformationDumpService.gitDebugInformation(gitInfoIndex, connector, sortedCommits, labeler);
            connection.close();
            return StringUtils.stringToBytes((String)JsonUtils.serializeToJSONPrettyPrinted((Object)debugInformation));
        }
        catch (ProjectConfigurationException | ConQATException | RepositoryException e) {
            throw new BadRequestException("Could not load connector " + this.repositoryId, e);
        }
    }

    @POST
    @Path(value="{repositoryId}/trigger-full-dump")
    @Operation(summary="Trigger full git debug dump", description="Triggers a complete debug dump of all labeling-related information during the next regularly scheduled commit tree expansion. This uses the infrastructure of the git debug dumper, which requires some environment variables to be set. Minimally, com.teamscale.debug-dump.enabled=true and com.teamscale.debug-dump.path=/some/path need to be set. Optionally, use com.teamscale.debug-dump.projects=(project1|project2) to restrict this further.", tags={"Debugging"}, responses={@ApiResponse(responseCode="400", description="The given repository ID is not valid."), @ApiResponse(responseCode="501", description="Debug dump requested, but debug dumper not enabled in system properties")})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public Response triggerGitDebugDumpOnNextCommitTreeExpansion(@Parameter(description="The ID of the repository") @PathParam(value="repositoryId") String repoId) {
        this.repositoryId = repoId;
        try {
            ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
            if (!DebugDumperRegistry.isEnabled((EDebugDumpEvent)EDebugDumpEvent.GIT_TRIGGERED_ROLLBACK, (ProjectInfo)projectIndex.resolveProject((IProjectId)this.serviceInfo.getInternalId()))) {
                return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)"Triggering a debug dump requires the system variables com.teamscale.debug-dump.enabled=true as well as com.teamscale.debug-dump.path=/some/path to be set.").build();
            }
            this.openGitInfoIndex().setDebugDumpRequested(true);
            return Response.ok((Object)"Debug dump requested successfully. It will be created during the next scheduled commit tree expansion.").build();
        }
        catch (ConQATException e) {
            throw new BadRequestException("Could not load repository " + this.repositoryId, (Throwable)e);
        }
    }

    private GitRepositoryConnector buildRepositoryConnector(GitRepositoryInfoIndex gitInfoIndex) throws StorageException, ProjectConfigurationException {
        GitRepositoryConnectorDescriptor repositoryConnectorDescriptor = this.getGitRepositoryConnectorDescriptor();
        return GitRepositoryConnectorUtils.createGitRepositoryConnector(repositoryConnectorDescriptor, gitInfoIndex, this.serviceInfo.getPrimaryPublicId(), this.repositoryId, this.getIndexLayer());
    }

    private GitRepositoryConnectorDescriptor getGitRepositoryConnectorDescriptor() throws BadRequestException, StorageException, ProjectConfigurationException {
        ConnectorConfiguration connectorInfo = this.getConnectors().stream().filter(connector -> Objects.equals(connector.getOptionValue("Repository identifier"), this.repositoryId)).findFirst().orElseThrow(() -> new BadRequestException("Could not find connector with name " + this.repositoryId));
        GlobalStorageSystem globalStorageSystem = this.getGlobalStorageSystem();
        ConfigurationInitializationContext context = new ConfigurationInitializationContext(this.getUser().getUsername(), this.getIndexLayer(), (IExternalCredentialsProvider)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.OTHER);
        ConnectorDescriptorBase loadedConnector = ConnectorUtils.loadConnector((ConnectorConfiguration)connectorInfo, (ConfigurationInitializationContext)context, (InternalProjectId)this.serviceInfo.getInternalId());
        if (!(loadedConnector instanceof GitRepositoryConnectorDescriptor)) {
            throw new BadRequestException("Connector with id " + this.repositoryId + " is not a git connector!");
        }
        return (GitRepositoryConnectorDescriptor)loadedConnector;
    }

    private List<ConnectorConfiguration> getConnectors() throws StorageException {
        return CollectionUtils.filter((Collection)((ProjectConfiguration)this.openProjectIndex(MetaIndex.class, null).getValue(ProjectConfiguration.class)).getConnectors(), config -> GIT_CONNECTOR_NAMES.contains(config.getType()));
    }

    private static PathBuildingBranchLabeler getPathBuildingBranchLabeler(GitRepositoryInfoIndex gitInfoIndex, GitRepositoryConnection connection, GitMainRepository repository) throws StorageException, RepositoryException {
        return new PathBuildingBranchLabeler(gitInfoIndex.getBranchNamesByCommitName(), Collections.emptyMap(), connection.buildCommitGraph((List)CollectionUtils.emptyList()), connection.getBranchPrioritizer(), arg_0 -> ((GitRepositoryConnection)connection).isBranchNameIncludedOrDefaultBranch(arg_0), repository);
    }

    private static GitDebugInformation gitDebugInformation(GitRepositoryInfoIndex gitInfoIndex, GitRepositoryConnector connector, ArrayList<TestCommitGraphNode> sortedCommits, PathBuildingBranchLabeler labeler) throws StorageException, RepositoryException {
        return new GitDebugInformation(sortedCommits, new PairList(gitInfoIndex.getBranchNamesByCommitName()), new PairList(labeler.extractBranchesWithHeadCommit()), connector.getBaseParameters().getDefaultBranchName());
    }

    private ArrayList<TestCommitGraphNode> getCommitsFromRepository(GitRepositoryConnection connection, GitMainRepository repository) throws RepositoryException, StorageException {
        HashMap<String, TestCommitGraphNode> idToCommitGraphNode = new HashMap<String, TestCommitGraphNode>();
        for (RevCommit revCommit : repository.getAllCommits()) {
            if (GitUtils.getCommitTime((RevCommit)revCommit).isBefore(connection.getAnalysisStart())) continue;
            TestCommitGraphNode testCommit = new TestCommitGraphNode(revCommit.getName(), revCommit.getFullMessage(), (long)revCommit.getCommitTime());
            idToCommitGraphNode.put(testCommit.getName(), testCommit);
        }
        this.resolveParentsAndBranchNames(connection, repository, idToCommitGraphNode);
        ArrayList<TestCommitGraphNode> commits = new ArrayList<TestCommitGraphNode>(idToCommitGraphNode.values());
        Collections.sort(commits);
        return commits;
    }

    private void resolveParentsAndBranchNames(GitRepositoryConnection connection, GitMainRepository repository, Map<String, TestCommitGraphNode> idToCommitGraphNode) throws RepositoryException, StorageException {
        CommitTreeIndex commitTree = this.openProjectIndex(CommitTreeIndex.class, CommitTreeIndex.getIndexNameForRepository((String)this.repositoryId), null);
        Map<String, String> commitNameToBranchMapping = commitTree.loadTree().getAllNodes().stream().collect(Collectors.toMap(node -> node.getRevision().getRevision(), node -> node.getRevision().getBranchName()));
        for (RevCommit revCommit : repository.getAllCommits()) {
            if (GitUtils.getCommitTime((RevCommit)revCommit).isBefore(connection.getAnalysisStart())) continue;
            TestCommitGraphNode commitNode = idToCommitGraphNode.get(revCommit.getName());
            for (RevCommit parent : revCommit.getParents()) {
                TestCommitGraphNode parentNode = idToCommitGraphNode.get(parent.getName());
                if (parentNode == null) continue;
                commitNode.addParent(parentNode);
            }
            commitNode.setBranchName(commitNameToBranchMapping.get(commitNode.getName()));
        }
    }

    private GitRepositoryInfoIndex openGitInfoIndex() throws StorageException {
        return this.openProjectIndex(GitRepositoryInfoIndex.class, GitRepositoryInfoIndex.createIndexName((String)this.repositoryId), null);
    }
}

