/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.worker.DetailedWorkerLog;
import com.teamscale.core.log.worker.ShortWorkerLog;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.LogServiceUtils;
import com.teamscale.service.framework.logging.ProjectLogLevelFrequencies;
import com.teamscale.service.framework.logging.ShortLogResponse;
import com.teamscale.service.logs.IProjectLogServiceApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/logs/worker")
public class WorkerLogProjectLogService
extends ApiBase
implements IProjectLogServiceApi<ShortWorkerLog, DetailedWorkerLog> {
    @Override
    @Operation(summary="Get all worker logs", description="Returns a list of all worker short logs.", tags={"Logging"}, operationId="getProjectWorkerLogs")
    public ShortLogResponse<ShortWorkerLog> getAllShortLogs(PublicProjectId project, LogFilteringParameters logFilteringParameters) throws StorageException {
        return LogServiceUtils.getShortLogs((LogFilteringParameters)logFilteringParameters, this.openWorkerLogIndexes(project));
    }

    @Override
    @Operation(summary="Get worker detail log", description="Returns the detailed worker log entry for the given timestamp.", tags={"Logging"}, operationId="getProjectWorkerLog")
    public DetailedWorkerLog getDetailedLog(PublicProjectId project, LogEntryIdentifier id) throws StorageException {
        return (DetailedWorkerLog)LogServiceUtils.getDetailedLogEntry(this.openWorkerLogIndexes(project), (LogEntryIdentifier)id);
    }

    @Override
    @Operation(summary="Get worker log frequencies", description="Returns the frequencies of the various worker log types (i.e. INFO/WARN/ERROR).", tags={"Logging"}, operationId="getProjectWorkerLogFrequencies")
    public List<ProjectLogLevelFrequencies> getLogFrequencies(PublicProjectId project) throws StorageException {
        return LogServiceUtils.obtainFrequencies(this.openWorkerLogIndexes(project));
    }

    @Override
    @Operation(summary="Download worker logs", description="Returns a file download of all worker logs.", tags={"Logging"}, operationId="downloadProjectWorkerLogs")
    public Response downloadLog(PublicProjectId project, LogFilteringParameters logFilteringParameters, int maxChars) throws StorageException {
        return LogServiceUtils.createLogDownload((String)"TeamscaleWorkerLogExport", (LogFilteringParameters)logFilteringParameters, (int)maxChars, this.openWorkerLogIndexes(project));
    }

    @Override
    @Operation(summary="Delete worker logs", description="Deletes all log entries in the specified project that match the applied filters.", tags={"Logging"}, operationId="deleteProjectWorkerLogs")
    public void deleteLogEntries(PublicProjectId project, LogFilteringParameters logFilteringParameters) throws StorageException {
        LogServiceUtils.deleteLogEntries((LogFilteringParameters)logFilteringParameters, this.openWorkerLogIndexes(project));
        AuditLogs.projectLogDeletion((String)"worker logs", (PublicProjectId)project);
    }

    private LogIndexesWrapper<ShortWorkerLog, DetailedWorkerLog> openWorkerLogIndexes(PublicProjectId project) throws StorageException {
        IndexLayer indexLayer = this.serviceInfo.getIndexLayer();
        PairList workerLogIndexes = PairList.from((Object)project, (Object)LogServiceUtils.determineIndexForProject((PublicProjectId)project, (IndexLayer)indexLayer, LogServiceUtils::getGlobalWorkerLogIndex, LogServiceUtils::getProjectWorkerLogIndex));
        Map workerLogDigestIndexes = LogServiceUtils.getDigestIndexesForProjects((IndexLayer)indexLayer, (Collection)workerLogIndexes.extractFirstList());
        return new LogIndexesWrapper(workerLogIndexes, workerLogDigestIndexes);
    }
}

