/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.mail;

import com.teamscale.core.mail.MailNotificationOption;
import com.teamscale.core.mail.MailUtils;
import com.teamscale.core.mail.SmtpServerOptions;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Collections;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/mail-settings/test")
public class MailTestService
extends ApiBase {
    @POST
    @Operation(summary="Send test e-mail", description="Allows to test sending of e-mails. This will attempt to send an e-mail to the e-mail address of the current user.", tags={"Debugging"}, responses={@ApiResponse(responseCode="400", description="The e-mail of the current user is invalid or not configured, or mail notifications are disabled"), @ApiResponse(responseCode="404", description="No mail server configured.")})
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_SERVER_OPTIONS})
    public void sendTestEmail() throws StorageException, MailUtils.MailException {
        String emailAddress = this.getUser().getEmailAddress();
        if (StringUtils.isEmpty((String)emailAddress)) {
            throw new BadRequestException("The e-mail address of the current user is not configured!");
        }
        if (!emailAddress.contains("@")) {
            throw new BadRequestException("The e-mail address of the current user is invalid: " + emailAddress);
        }
        SmtpServerOptions mailOptions = MailUtils.getMailOptions((GlobalStorageSystem)this.getGlobalStorageSystem());
        if (mailOptions == null || StringUtils.isEmpty((String)mailOptions.host)) {
            throw new NotFoundException("No mail server configured. Please configure the server in the Mail Server Settings.");
        }
        MailNotificationOption notificationOption = MailUtils.getNotificationOption((ServerOptionIndex)this.openGlobalIndex(ServerOptionIndex.class));
        if (!notificationOption.isMailsActivated) {
            throw new BadRequestException("Warning: Mail notifications are disabled, no email can be sent. Check 'Mail Notification Settings'!");
        }
        MailUtils mailUtils = new MailUtils(mailOptions);
        mailUtils.sendHtmlMail(Collections.singletonList(emailAddress), "Teamscale Test Mail", "If you received this e-mail, <b>Teamscale's</b> mail support is configured correctly.", this.getGlobalStorageSystem());
    }
}

