/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.debug;

import com.google.common.base.Preconditions;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.git.common.merge_request_statistics.MergeRequestStatisticsCollector;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jetbrains.annotations.TestOnly;

@Hidden
@Path(value="api/merge-requests/debug/statistics")
@TestOnly
public class DebugMergeRequestStatisticsService
extends ApiBase {
    private static final List<String> COLLECTED_ROWS = new ArrayList<String>();

    @POST
    @Path(value="enable")
    @Operation(tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void enableInMemoryMergeRequestStatisticsForTesting() {
        DebugMergeRequestStatisticsService.assertDevOrTestMode();
        DateTimeUtils.setFixedClock((Instant)Instant.ofEpochMilli(1731855468234L));
        MergeRequestStatisticsCollector.setRowConsumerForTesting(DebugMergeRequestStatisticsService::collectInMemory);
    }

    @POST
    @Path(value="reset")
    @Operation(tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void resetInMemoryMergeRequestStatisticsForTesting() {
        DebugMergeRequestStatisticsService.assertDevOrTestMode();
        COLLECTED_ROWS.clear();
        DateTimeUtils.resetClock();
        MergeRequestStatisticsCollector.resetRowConsumerForTesting();
    }

    @GET
    @Path(value="read")
    @Operation(tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"application/json"})
    public List<String> readInMemoryMergeRequestStatisticRows() {
        DebugMergeRequestStatisticsService.assertDevOrTestMode();
        return COLLECTED_ROWS;
    }

    private static void collectInMemory(Object ... objects) {
        COLLECTED_ROWS.add(Arrays.stream(objects).map(Object::toString).collect(Collectors.joining(";")));
    }

    private static void assertDevOrTestMode() {
        Preconditions.checkState((EFeatureToggle.isInUiDevServerMode() || EFeatureToggle.isInUiTestServerMode() ? 1 : 0) != 0, (Object)"Service is only available in dev or test mode.");
    }
}

