/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.metrics;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.index.dependencies.NearestNeighborFileDependencyFilteringStrategy;
import com.teamscale.index.findings.calculation.NonCodeBinarySizeElementFindingsRetriever;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.service.merge_request.metrics.DeltaEntry;
import com.teamscale.service.merge_request.metrics.EChangeType;
import com.teamscale.service.merge_request.metrics.MergeRequestSingleMetricDetailsUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

class MergeRequestSingleMetricDetailsBinarySizeUtils {
    private MergeRequestSingleMetricDetailsBinarySizeUtils() {
    }

    static void transformDeltasForRefactorings(Map<String, DeltaEntry> deltasByUniformPath, List<MetricDirectoryEntry> startEntries, List<MetricDirectoryEntry> endEntries, Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> startPathToContent, Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> endPathToContent, int metricIndex, boolean filterUnchangedEntries) {
        List<Refactoring> entityRefactorings = MergeRequestSingleMetricDetailsBinarySizeUtils.determineRefactorings(metricIndex, startEntries, endEntries, startPathToContent, endPathToContent);
        for (Refactoring entityRefactoring : entityRefactorings) {
            deltasByUniformPath.remove(entityRefactoring.removedPath());
            if (filterUnchangedEntries) {
                deltasByUniformPath.remove(entityRefactoring.addedPath());
                continue;
            }
            deltasByUniformPath.put(entityRefactoring.addedPath(), new DeltaEntry(0.0, 0.0, 0.0, EChangeType.UNCHANGED));
        }
    }

    public static Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> getNonCodeLinkContent(List<MetricDirectoryEntry> metricDirectoryEntries, BasicTokenElementIndex basicTokenElementIndex) throws StorageException {
        HashMap<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> nonCodePathToContent = new HashMap<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent>();
        PairList uniformPaths = new PairList();
        for (MetricDirectoryEntry metricDirectoryEntry : metricDirectoryEntries) {
            MergeRequestSingleMetricDetailsBinarySizeUtils.getUniformPathFromNonCodeEntry(metricDirectoryEntry).ifPresent(uniformPath -> uniformPaths.add((Object)metricDirectoryEntry, (Object)uniformPath.toString()));
        }
        List basicElements = basicTokenElementIndex.getTokenElements(uniformPaths.extractSecondList());
        for (int i = 0; i < uniformPaths.size(); ++i) {
            MetricDirectoryEntry entry = (MetricDirectoryEntry)uniformPaths.getFirst(i);
            BasicTokenElementInfo basicElement = (BasicTokenElementInfo)basicElements.get(i);
            if (basicElement == null) continue;
            try {
                NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent link = (NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent)JsonUtils.deserializeFromJson((String)basicElement.getText(), NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent.class);
                nonCodePathToContent.put(entry.getUniformPath(), link);
                continue;
            }
            catch (JsonSerializationException jsonSerializationException) {
                // empty catch block
            }
        }
        return nonCodePathToContent;
    }

    private static Optional<UniformPath> getUniformPathFromNonCodeEntry(MetricDirectoryEntry entry) {
        if (entry.getUniformPath().isEmpty()) {
            return Optional.empty();
        }
        UniformPath uniformPath = UniformPath.ofSegments((String[])UniformPathUtils.splitPath((String)entry.getUniformPath()));
        if (uniformPath.isNonCodePath()) {
            return Optional.of(uniformPath);
        }
        return Optional.empty();
    }

    private static @NonNull List<Refactoring> determineRefactorings(int metricIndex, List<MetricDirectoryEntry> startEntries, List<MetricDirectoryEntry> endEntries, Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> startPathToContent, Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> endPathToContent) throws IllegalArgumentException {
        Map<String, @NonNull Double> startValues = MergeRequestSingleMetricDetailsUtils.getDoubleValuesByPath(startEntries, metricIndex);
        Map<String, @NonNull Double> endValues = MergeRequestSingleMetricDetailsUtils.getDoubleValuesByPath(endEntries, metricIndex);
        ArrayList<Refactoring> refactorings = new ArrayList<Refactoring>();
        for (RefactoringGroup refactoringGroup : MergeRequestSingleMetricDetailsBinarySizeUtils.aggregateRefactoringGroups(startValues, endValues)) {
            refactorings.addAll(MergeRequestSingleMetricDetailsBinarySizeUtils.findRenameAtSameLocation(refactoringGroup, startPathToContent, endPathToContent));
            refactorings.addAll(MergeRequestSingleMetricDetailsBinarySizeUtils.findMoveAtSameFile(refactoringGroup));
            refactorings.addAll(MergeRequestSingleMetricDetailsBinarySizeUtils.findRenameAtSameFile(refactoringGroup));
            refactorings.addAll(MergeRequestSingleMetricDetailsBinarySizeUtils.findMoveToDifferentFile(refactoringGroup));
            refactorings.addAll(MergeRequestSingleMetricDetailsBinarySizeUtils.findOtherSymbolWithClosestDistance(refactoringGroup));
        }
        return refactorings;
    }

    private static List<RefactoringGroup> aggregateRefactoringGroups(Map<String, @NonNull Double> startValues, Map<String, @NonNull Double> endValues) {
        HashSet<String> addedPaths = new HashSet<String>(CollectionUtils.differenceSet(endValues.keySet(), (Collection[])new Collection[]{startValues.keySet()}));
        HashSet removedPaths = CollectionUtils.differenceSet(startValues.keySet(), (Collection[])new Collection[]{endValues.keySet()});
        HashMap<CallSite, RefactoringGroup> groups = new HashMap<CallSite, RefactoringGroup>();
        for (String removedPath : removedPaths) {
            Double value = startValues.get(removedPath);
            String[] pathElements = UniformPathUtils.splitPath((String)removedPath);
            if (pathElements.length < 4) continue;
            String key = value + ";" + MergeRequestSingleMetricDetailsBinarySizeUtils.extractSectionPrefix(pathElements);
            RefactoringGroup group = groups.getOrDefault(key, RefactoringGroup.buildWithAddedPaths(value, addedPaths, endValues));
            group.removedPaths.add(removedPath);
            groups.put((CallSite)((Object)key), group);
        }
        return groups.values().stream().toList();
    }

    private static List<Refactoring> applyFindFunction(RefactoringGroup refactoringGroup, Function<String, Optional<String>> findFunction) {
        ArrayList<Refactoring> refactorings = new ArrayList<Refactoring>();
        ArrayList foundRefactoringPaths = new ArrayList();
        for (String removedPath : refactoringGroup.removedPaths) {
            findFunction.apply(removedPath).ifPresent(addedPath -> {
                refactorings.add(new Refactoring(removedPath, (String)addedPath));
                refactoringGroup.addedPaths.remove(addedPath);
                foundRefactoringPaths.add(removedPath);
            });
        }
        refactoringGroup.removedPaths.removeAll(foundRefactoringPaths);
        return refactorings;
    }

    private static List<Refactoring> findRenameAtSameLocation(RefactoringGroup refactoringGroup, Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> startPathToContent, Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> endPathToContent) {
        return MergeRequestSingleMetricDetailsBinarySizeUtils.applyFindFunction(refactoringGroup, removedPath -> {
            NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent removedSymbolLink = (NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent)startPathToContent.get(removedPath);
            if (removedSymbolLink == null) {
                return Optional.empty();
            }
            return refactoringGroup.addedPaths.stream().filter(addedPath -> removedSymbolLink.equals(endPathToContent.get(addedPath))).findFirst();
        });
    }

    private static List<Refactoring> findMoveAtSameFile(RefactoringGroup refactoringGroup) {
        return MergeRequestSingleMetricDetailsBinarySizeUtils.applyFindFunction(refactoringGroup, removedPath -> {
            String removedFile = MergeRequestSingleMetricDetailsBinarySizeUtils.extractPrefix(removedPath);
            String removedSymbolName = MergeRequestSingleMetricDetailsBinarySizeUtils.extractSuffix(removedPath);
            return refactoringGroup.addedPaths.stream().filter(addedPath -> {
                String addedFile = MergeRequestSingleMetricDetailsBinarySizeUtils.extractPrefix(addedPath);
                String addedSymbolName = MergeRequestSingleMetricDetailsBinarySizeUtils.extractSuffix(addedPath);
                return addedFile.equals(removedFile) && addedSymbolName.equals(removedSymbolName);
            }).findFirst();
        });
    }

    private static List<Refactoring> findRenameAtSameFile(RefactoringGroup refactoringGroup) {
        return MergeRequestSingleMetricDetailsBinarySizeUtils.applyFindFunction(refactoringGroup, removedPath -> {
            String removedFile = MergeRequestSingleMetricDetailsBinarySizeUtils.extractPrefix(removedPath);
            return refactoringGroup.addedPaths.stream().filter(addedPath -> {
                String addedFile = MergeRequestSingleMetricDetailsBinarySizeUtils.extractPrefix(addedPath);
                return addedFile.equals(removedFile);
            }).findFirst();
        });
    }

    private static List<Refactoring> findMoveToDifferentFile(RefactoringGroup refactoringGroup) {
        return MergeRequestSingleMetricDetailsBinarySizeUtils.applyFindFunction(refactoringGroup, removedPath -> {
            String removedSymbolName = MergeRequestSingleMetricDetailsBinarySizeUtils.extractSuffix(removedPath);
            List<String> movedPaths = refactoringGroup.addedPaths.stream().filter(addedPath -> {
                String addedSymbolName = MergeRequestSingleMetricDetailsBinarySizeUtils.extractSuffix(addedPath);
                return addedSymbolName.equals(removedSymbolName);
            }).toList();
            return MergeRequestSingleMetricDetailsBinarySizeUtils.findOtherSymbolWithClosestDistance(removedPath, movedPaths);
        });
    }

    private static List<Refactoring> findOtherSymbolWithClosestDistance(RefactoringGroup refactoringGroup) {
        return MergeRequestSingleMetricDetailsBinarySizeUtils.applyFindFunction(refactoringGroup, removedPath -> MergeRequestSingleMetricDetailsBinarySizeUtils.findOtherSymbolWithClosestDistance(removedPath, refactoringGroup.addedPaths));
    }

    private static Optional<String> findOtherSymbolWithClosestDistance(String removedPath, List<String> addedPaths) {
        if (addedPaths.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(NearestNeighborFileDependencyFilteringStrategy.getNearestPath((String)removedPath, addedPaths));
    }

    private static String extractSectionPrefix(String[] pathElements) {
        return pathElements[0] + "/" + pathElements[1] + "/" + pathElements[2] + "/" + pathElements[3] + "/";
    }

    private static String extractPrefix(String uniformPath) {
        return StringUtils.substringBeforeLast((String)uniformPath, (String)"/");
    }

    private static String extractSuffix(String uniformPath) {
        String[] pathElements = UniformPathUtils.splitPath((String)uniformPath);
        return pathElements[pathElements.length - 1];
    }

    private record Refactoring(String removedPath, String addedPath) {
    }

    private record RefactoringGroup(List<String> removedPaths, List<String> addedPaths) {
        public static RefactoringGroup buildWithAddedPaths(double value, Set<String> addedPaths, Map<String, @NonNull Double> endValues) {
            RefactoringGroup newGroup = new RefactoringGroup(new ArrayList<String>(), new ArrayList<String>());
            for (String addedPath : addedPaths) {
                Double addedValue = endValues.get(addedPath);
                if (!MergeRequestSingleMetricDetailsUtils.isZero(addedValue - value)) continue;
                newGroup.addedPaths.add(addedPath);
            }
            return newGroup;
        }
    }
}

