/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.merge_request.BranchPointNotFoundException;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.AssociatedMethodTestInfo;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.TestGapEnablementChecker;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.ITgaRequest;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaIssueAndMergeRequestOptions;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.LineOffsetUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/code/{uniformPath}/methods")
public class MethodsService
extends ApiBase {
    @GET
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get methods", description="Returns the list of methods for a given file.", tags={"Metrics"}, responses={@ApiResponse(responseCode="404", description="The requested uniformPath does not exist!")})
    public List<LineBasedMethodInfo> getMethodsForFile(@PathParam(value="uniformPath") @ResolveToCodePath UniformPath uniformPath, @BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalBasedParameters, @BeanParam TgaIssueAndMergeRequestOptions tgaIssueAndMergeRequestOptions, @BeanParam IssueTgaParameters issueTgaParameters, @BeanParam CoverageSourceQueryParameters coverageSourceParameters) throws StorageException, RepositoryException, BranchPointNotFoundException {
        if (!uniformPath.isCodePath()) {
            return new ArrayList<LineBasedMethodInfo>();
        }
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(timeIntervalBasedParameters.getEndCommit());
        return this.loadMethodsWithTestGapInfo(uniformPath, historyAccessOption, coverageSourceParameters, timeIntervalBasedParameters, new TgaRequestQueryOptions(uniformPath, tgaIssueAndMergeRequestOptions), issueTgaParameters);
    }

    private List<LineBasedMethodInfo> loadMethodsWithTestGapInfo(UniformPath uniformPath, HistoryAccessOption historyAccessOption, CoverageSourceQueryParameters coverageSourceParameters, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, TgaRequestQueryOptions tgaRequestQueryOptions, IssueTgaParameters issueTgaParameters) throws StorageException, RepositoryException, BranchPointNotFoundException {
        PairList<AssociatedMethodInfo, Optional<AssociatedMethodTestInfo>> methodData = this.loadMethodData(uniformPath, coverageSourceParameters.getPartitions(), historyAccessOption);
        if (methodData.isEmpty()) {
            return Collections.emptyList();
        }
        TokenElementLineInfoIndex tokenElementLineInfoIndex = (TokenElementLineInfoIndex)this.getProjectStorageSystem().openProjectIndex(TokenElementLineInfoIndex.class, historyAccessOption);
        TokenElementLineInfo lineInfo = tokenElementLineInfoIndex.getLineInfo(uniformPath.toString());
        if (lineInfo == null) {
            throw new NotFoundException("No line information found for " + String.valueOf(uniformPath) + "!");
        }
        ITgaRequest tgaRequest = this.createTgaRequest(timeIntervalParameters, coverageSourceParameters, tgaRequestQueryOptions, issueTgaParameters);
        AssessedTgaData assessedTgaData = tgaRequest.fetchAndAssessData();
        CommitDescriptor commit = tgaRequest.getIndexAccessCommit();
        HistoryAccessOption readAccess = HistoryAccessOption.readCommit((CommitDescriptor)commit);
        ExtendedResourceTypeIndex extendedResourceTypeIndex = this.openProjectIndex(ExtendedResourceTypeIndex.class, readAccess);
        CodeScopesMappingIndex codeScopesMappingIndex = this.openProjectIndex(CodeScopesMappingIndex.class, readAccess);
        CodeScopeAware tgaEnablementPerCodeScope = TgaRequestUtils.getTgaEnablementPerCodeScope((ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem());
        return MethodsService.convertToLineBasedRegions(extendedResourceTypeIndex, methodData, lineInfo.getRawLineOffsetConverter(), assessedTgaData.getMethods().stream().collect(Collectors.toMap(AssessedTgaData.AssessedMethodData::getLocation, Function.identity())), codeScopesMappingIndex, (CodeScopeAware<Boolean>)tgaEnablementPerCodeScope);
    }

    private PairList<AssociatedMethodInfo, Optional<AssociatedMethodTestInfo>> loadMethodData(UniformPath uniformPath, List<String> partitions, HistoryAccessOption historyAccessOption) throws StorageException {
        MethodInfoIndex methodInfoIndex = this.openProjectIndex(MethodInfoIndex.class, historyAccessOption);
        MethodLastTestedIndex methodLastTestedIndex = this.openProjectIndex(MethodLastTestedIndex.class, historyAccessOption);
        if (partitions.isEmpty()) {
            partitions = methodLastTestedIndex.getPartitions();
        }
        List methodInfos = methodInfoIndex.getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(Collections.singletonList(uniformPath.toString()));
        List methodTimestamps = methodLastTestedIndex.getTestInfosForPartitionsAndExactPath(partitions, uniformPath.toString());
        PairList result = new PairList();
        for (AssociatedMethodInfo methodInfo : methodInfos) {
            Optional<AssociatedMethodTestInfo> methodTimestamp = methodTimestamps.stream().filter(associatedMethodTimestamp -> associatedMethodTimestamp.getLocation().equals((Object)methodInfo.getLocation())).max(Comparator.comparing(AssociatedMethodTestInfo::getTimestamp));
            result.add((Object)methodInfo, methodTimestamp);
        }
        return result;
    }

    private ITgaRequest createTgaRequest(TimeIntervalBasedServiceQueryOptions timeIntervalParameters, CoverageSourceQueryParameters coverageSourceQueryParameters, TgaRequestQueryOptions tgaRequestQueryOptions, IssueTgaParameters issueTgaParameters) throws StorageException, RepositoryException, BranchPointNotFoundException {
        return ITgaRequest.createRequest((CoverageSourceParameterBase)coverageSourceQueryParameters, (TimeIntervalBasedServiceQueryOptions)timeIntervalParameters, (TgaRequestQueryOptions)tgaRequestQueryOptions, (IssueTgaParameters)issueTgaParameters, (ETgaAssessmentType)ETgaAssessmentType.TEST_GAP, (IndexLayer)this.getIndexLayer(), (IProjectId)this.serviceInfo.getPrimaryPublicId(), (User)this.getUser());
    }

    private static List<LineBasedMethodInfo> convertToLineBasedRegions(ExtendedResourceTypeIndex extendedResourceTypeIndex, PairList<AssociatedMethodInfo, Optional<AssociatedMethodTestInfo>> methodData, LineOffsetConverter lineOffsetConverter, Map<MethodLocation, AssessedTgaData.AssessedMethodData> methods, CodeScopesMappingIndex codeScopesMappingIndex, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) throws StorageException {
        ArrayList<LineBasedMethodInfo> result = new ArrayList<LineBasedMethodInfo>();
        ArrayList uniformPaths = new ArrayList(CollectionUtils.mapToSet((Collection)methodData.getFirstList(), AssociatedMethodInfo::getUniformPath));
        TestGapEnablementChecker tgaEnablementChecker = new TestGapEnablementChecker(uniformPaths, codeScopesMappingIndex, tgaEnablementPerCodeScope);
        Set testUniformPaths = extendedResourceTypeIndex.getTestCodePaths(uniformPaths);
        for (int i = 0; i < methodData.size(); ++i) {
            AssociatedMethodInfo methodInfo = (AssociatedMethodInfo)methodData.getFirst(i);
            Optional methodTimestamp = (Optional)methodData.getSecond(i);
            LineBasedRegion lineBasedRegion = LineOffsetUtils.convertToLineRegion((OffsetBasedRegion)methodInfo.getLocation().getRegion(), (LineOffsetConverter)lineOffsetConverter);
            long lastTestedTimestamp = 0L;
            if (methodTimestamp.isPresent()) {
                lastTestedTimestamp = ((AssociatedMethodTestInfo)methodTimestamp.get()).getTimestamp();
            }
            boolean isTestCode = testUniformPaths.contains(methodInfo.getLocation().getUniformPath());
            boolean isTgaEnabled = tgaEnablementChecker.isTgaEnabled(methodInfo.getLocation().getUniformPath());
            AssessedTgaData.AssessedMethodData assessedMethodData = methods.get(methodInfo.getLocation());
            if (assessedMethodData == null) {
                result.add(new LineBasedMethodInfo(methodInfo.getMethodName(), methodInfo.getLocation(), lineBasedRegion, methodInfo.getLastChangedTimestamp(), lastTestedTimestamp, methodInfo.isTrivial(), isTestCode, (ETestGapState)(methodInfo.isRelevantForTgaTreemap(isTestCode, isTgaEnabled) ? ETestGapState.UNCHANGED : null)));
                continue;
            }
            result.add(new LineBasedMethodInfo(assessedMethodData.getMethodName(), assessedMethodData.getLocation(), lineBasedRegion, assessedMethodData.getLastChangeTimestamp(), assessedMethodData.getLastTestTimestamp(), methodInfo.isTrivial(), isTestCode, assessedMethodData.getTestGapState()));
        }
        return result;
    }

    public record LineBasedMethodInfo(@JsonProperty(value="name") String name, @JsonProperty(value="location") MethodLocation location, @JsonProperty(value="lineBasedRegion") LineBasedRegion lineBasedRegion, @JsonProperty(value="lastChangedTimestamp") long lastChangedTimestamp, @JsonProperty(value="lastTestedTimestamp") long lastTestedTimestamp, @JsonProperty(value="isTrivial") boolean isTrivial, @JsonProperty(value="isTestCode") boolean isTestCode, @JsonProperty(value="testGapStatus") @Nullable ETestGapState testGapStatus) {
    }
}

