/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap.builder;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.metrics.treemap.builder.NumericValueTreeMapBuilderBase;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;

public class FindingsTreeMapBuilder
extends NumericValueTreeMapBuilderBase<Integer, TreeMapNode> {
    private final List<? extends TrackedFinding> findings;
    private final MetricsToArchitectureMetricsMappingIndex mappingIndex;
    private final CounterSet<String> pathsWithFindingCount = new CounterSet();

    public FindingsTreeMapBuilder(List<? extends TrackedFinding> findings, IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, Color baseColor, MetricsToArchitectureMetricsMappingIndex mappingIndex) {
        super(null, null, historyAccessOption, metricRetrievalStrategy, areaMetricIndex, null, baseColor, -1.0, -1.0, false);
        this.findings = findings;
        this.mappingIndex = mappingIndex;
    }

    @Override
    protected Map<String, Integer> calculateValues(String pathPrefix) throws StorageException {
        Map alreadyFoundUniformPathMap = new HashMap();
        if (ArchitectureMetricsUtils.isArchitectureArtifactPath((String)pathPrefix)) {
            alreadyFoundUniformPathMap = ArchitectureMetricsUtils.getRecursivePathMappings((MetricsToArchitectureMetricsMappingIndex)this.mappingIndex, (String)pathPrefix);
        }
        for (TrackedFinding trackedFinding : this.findings) {
            String uniformPath = trackedFinding.getLocation().getUniformPath();
            if (alreadyFoundUniformPathMap.containsKey(uniformPath)) {
                uniformPath = (String)alreadyFoundUniformPathMap.get(trackedFinding.getLocation().getUniformPath());
            }
            this.pathsWithFindingCount.inc((Object)uniformPath);
        }
        return this.pathsWithFindingCount.toMap();
    }

    @Override
    protected Pair<Double, Double> determineValueRangeFromMetric(int metricIndex, List<MetricDirectoryEntry> entries) {
        if (this.pathsWithFindingCount.isEmpty()) {
            return Pair.createPair((Object)0.0, (Object)0.0);
        }
        Double min = null;
        Double max = null;
        for (MetricDirectoryEntry entry : entries) {
            int findingCount = this.pathsWithFindingCount.getValue((Object)entry.getUniformPath());
            if (min == null || (double)findingCount < min) {
                min = findingCount;
            }
            if (max != null && !((double)findingCount > max)) continue;
            max = findingCount;
        }
        return Pair.createPair(min, max);
    }

    @Override
    protected TreeMapNode createNode(MetricDirectoryEntry entry) throws StorageException {
        return new TreeMapNode(entry.getUniformPath(), entry.getDoubleValue(this.areaMetricIndex), this.formatMetricValue(entry.getValueOrDefault(this.builderParameters.colorMetricIndex, this.builderParameters.colorMetricDefault)), this.determineColor(entry));
    }
}

