/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.logging.ICriticalEventLogger;
import com.teamscale.service.project.ProjectServiceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import retrofit2.http.Body;

@Path(value="api/projects/reanalyze")
public class MultiProjectReanalysisService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @Context
    private ICriticalEventLogger criticalEventLogger;

    @POST
    @RequiresNoPermission(description="The API requires the user to have Edit Project permissions on all provided projects.")
    @Operation(summary="Trigger multi-project re-analysis.", description="Triggers re-analysis of all projects specified in the request body (a list of project ids).", tags={"Project"})
    public TriggerMultiReanalysisResult triggerMultiReanalysis(@Body List<PublicProjectId> projectIds, @Parameter(description="Whether the projects should be validated when triggering the reanalysis") @QueryParam(value="validate-projects") @DefaultValue(value="true") boolean validateProjects) throws StorageException {
        this.verifyProjectPermissions(projectIds);
        ArrayList<PublicProjectId> successfulProjects = new ArrayList<PublicProjectId>();
        HashMap<PublicProjectId, String> failedProjectsWithMessages = new HashMap<PublicProjectId, String>();
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        for (PublicProjectId projectId : projectIds) {
            InternalProjectId internalProjectId = projectIndex.resolveToInternalId((IProjectId)projectId);
            try {
                ProjectServiceUtils.triggerReanalysis(internalProjectId, this.serviceInfo, validateProjects);
                this.criticalEventLogger.logCriticalEventMessage((IProjectId)projectId, "Project re-analysis event");
                successfulProjects.add(projectId);
            }
            catch (RuntimeException | StorageException e) {
                LOGGER.warn("Failed to re-analyze project: {}", (Object)projectId, (Object)e);
                failedProjectsWithMessages.put(projectId, e.getMessage());
            }
        }
        return new TriggerMultiReanalysisResult(successfulProjects, failedProjectsWithMessages);
    }

    private void verifyProjectPermissions(List<PublicProjectId> projectIds) throws StorageException {
        ServicePermissions permissions = this.getPermissions();
        for (PublicProjectId projectId : projectIds) {
            try {
                permissions.checkProjectPermission((IProjectId)projectId, EProjectPermission.EDIT);
            }
            catch (ForbiddenException e) {
                throw new NotFoundException("Project " + String.valueOf(projectId) + " doesn't exist or you don\u2019t have the necessary permissions!", (Throwable)e);
            }
        }
    }

    public record TriggerMultiReanalysisResult(List<PublicProjectId> successfulProjects, Map<PublicProjectId, String> failedProjectsWithError) {
    }
}

