/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SelfContainedFinding;
import com.teamscale.index.quality_report.slides.TaskDetailSlide;
import com.teamscale.index.repository.RepositoryLastChangeUtils;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.task.CodeSnippet;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskIndex;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.service.reports.ReportSlideWithRenderData;
import com.teamscale.service.reports.slides.ReportUtils;
import com.teamscale.service.reports.slides.SlideRenderContext;
import com.teamscale.service.reports.slides.SlideRendererBase;
import eu.cqse.check.framework.scanner.IToken;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class TaskDetailSlideRenderer
extends SlideRendererBase<TaskDetailSlide.TaskDetailSlideParameters> {
    private static final int MAX_LINE_COUNT_PER_SNIPPET = 6;
    private static final int MAX_LINE_COUNT_PER_SLIDE = 18;
    private static final int LINES_COUNT_AROUND_FINDING_SNIPPET = 10;

    public TaskDetailSlideRenderer(SlideRenderContext<TaskDetailSlide.TaskDetailSlideParameters> slideRenderContext) {
        super(slideRenderContext);
    }

    public TaskDetailSlide.TaskDetailSlideResult createSlideResult(@Nullable ReportSlideWithRenderData existingSlide) throws StorageException {
        int taskId;
        ProjectBranchPath projectBranchPath = ((TaskDetailSlide.TaskDetailSlideParameters)this.getParameters()).getProjectBranchPath();
        try {
            taskId = Integer.parseInt(((TaskDetailSlide.TaskDetailSlideParameters)this.getParameters()).getTaskId());
        }
        catch (NumberFormatException ex) {
            taskId = 0;
        }
        String userSlideTitle = ((TaskDetailSlide.TaskDetailSlideParameters)this.getParameters()).getSlideTitle();
        List comments = ((TaskDetailSlide.TaskDetailSlideParameters)this.getParameters()).getComments();
        return this.getSlideResult(projectBranchPath, taskId, userSlideTitle, comments, this.getReportProfile().getEndWithType().getTimestamp());
    }

    private TaskDetailSlide.TaskDetailSlideResult getSlideResult(ProjectBranchPath projectBranchPath, int taskId, String userSlideTitle, List<ISlideComment> comments, long reportProfileEndTimestamp) throws StorageException {
        IStorageInfo projectStorageInfo = this.renderContext.resolveProjectAndReturnLocalStorageInfo(projectBranchPath);
        TaskIndex taskIndex = (TaskIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(TaskIndex.class, null);
        Task task = taskIndex.getTask(taskId);
        if (task == null) {
            return new TaskDetailSlide.TaskDetailSlideResult(userSlideTitle, Collections.emptyList(), this.getSlideCommentRenderData(projectBranchPath, comments));
        }
        String slideTitle = userSlideTitle;
        if (StringUtils.isEmpty((String)userSlideTitle)) {
            slideTitle = MessageFormat.format("Task #{0}: {1}", taskId, task.getSubject());
        }
        return new TaskDetailSlide.TaskDetailSlideResult(slideTitle, TaskDetailSlideRenderer.getCodeSnippets(projectBranchPath, reportProfileEndTimestamp, projectStorageInfo, task), this.getSlideCommentRenderData(projectBranchPath, comments));
    }

    private static List<TaskDetailSlide.TaskDetailSlideCodeSnippet> getCodeSnippets(ProjectBranchPath projectBranchPath, long reportProfileEndTimestamp, IStorageInfo projectStorageInfo, Task task) throws StorageException {
        UnresolvedCommitDescriptor unresolvedCommit = ReportUtils.buildCommit(projectBranchPath.getBranch(), reportProfileEndTimestamp);
        CommitDescriptor reportEndCommit = UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)unresolvedCommit, () -> ((IStorageInfo)projectStorageInfo).getProjectStorageSystem());
        HistoryAccessOption accessAtReportEnd = HistoryAccessOption.readTimestamp((String)reportEndCommit.getBranchName(), (long)reportEndCommit.getTimestamp());
        TrackedFindingsByIdIndex findingsIndex = (TrackedFindingsByIdIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(TrackedFindingsByIdIndex.class, accessAtReportEnd);
        List<TaskDetailSlide.TaskDetailSlideCodeSnippet> codeSnippets = TaskDetailSlideRenderer.getManuallyAddedCodeSnippets(projectStorageInfo, task);
        if (codeSnippets.isEmpty()) {
            codeSnippets = TaskDetailSlideRenderer.getCodeSnippetsFromFindings(findingsIndex, reportEndCommit, projectStorageInfo, task);
        }
        return codeSnippets;
    }

    private static List<TaskDetailSlide.TaskDetailSlideCodeSnippet> getManuallyAddedCodeSnippets(IStorageInfo projectStorageInfo, Task task) throws StorageException {
        ArrayList<TaskDetailSlide.TaskDetailSlideCodeSnippet> taskDetailSlideCodeSnippets = new ArrayList<TaskDetailSlide.TaskDetailSlideCodeSnippet>();
        List codeSnippets = task.getCodeSnippets();
        int countOfCodeLines = 0;
        for (CodeSnippet codeSnippet : codeSnippets) {
            CommitDescriptor commitDescriptor = codeSnippet.getCommit();
            HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commitDescriptor);
            int numberOfCodeSnippetLines = codeSnippet.getLocation().getRawEndLine() - codeSnippet.getLocation().getRawStartLine() + 1;
            if (numberOfCodeSnippetLines > 6) {
                numberOfCodeSnippetLines = 6;
            }
            if ((countOfCodeLines += numberOfCodeSnippetLines) > 18) break;
            TaskDetailSlide.TaskDetailSlideCodeSnippet taskSlideCodeSnippet = TaskDetailSlideRenderer.createTaskSlideCodeSnippet(projectStorageInfo, codeSnippet, historyAccessOption);
            if (taskSlideCodeSnippet == null) continue;
            taskDetailSlideCodeSnippets.add(taskSlideCodeSnippet);
        }
        return taskDetailSlideCodeSnippets;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable TaskDetailSlide.TaskDetailSlideCodeSnippet createTaskSlideCodeSnippet(IStorageInfo projectStorageInfo, CodeSnippet codeSnippet, HistoryAccessOption historyAccessOption) throws StorageException {
        FormattedTokenElementInfo tokenElementInfo = ReportUtils.loadSourceCodeForPath(codeSnippet.getLocation().getUniformPath(), projectStorageInfo, historyAccessOption);
        if (tokenElementInfo == null) {
            return null;
        }
        TaskDetailSlide.TaskDetailSlideCodeSnippet taskDetailSlideCodeSnippet = new TaskDetailSlide.TaskDetailSlideCodeSnippet(codeSnippet.getLocation(), codeSnippet.getCommit(), codeSnippet.getFindingIds(), codeSnippet.getTimeCreated(), codeSnippet.shouldRenderFromFinding(), new SelfContainedFinding.FindingContent(tokenElementInfo));
        TrackedFindingsByIdIndex findingsIndex = (TrackedFindingsByIdIndex)projectStorageInfo.getProjectStorageSystem().openProjectIndex(TrackedFindingsByIdIndex.class, historyAccessOption);
        for (String findingId : codeSnippet.getFindingIds()) {
            TrackedFinding trackedFinding = findingsIndex.getFinding(findingId);
            if (trackedFinding == null) continue;
            SelfContainedFinding finding = SelfContainedFinding.from((TrackedFinding)trackedFinding, (FormattedTokenElementInfo)tokenElementInfo);
            taskDetailSlideCodeSnippet.addFinding(finding);
        }
        return taskDetailSlideCodeSnippet;
    }

    private static List<TaskDetailSlide.TaskDetailSlideCodeSnippet> getCodeSnippetsFromFindings(TrackedFindingsByIdIndex findingsIndex, CommitDescriptor reportEndCommit, IStorageInfo projectStorageInfo, Task task) throws StorageException {
        ArrayList<TaskDetailSlide.TaskDetailSlideCodeSnippet> taskDetailSlideCodeSnippets = new ArrayList<TaskDetailSlide.TaskDetailSlideCodeSnippet>();
        long snippetCreationTime = System.currentTimeMillis();
        int countOfCodeLines = 0;
        for (String findingId : task.getFindingIds()) {
            CommitDescriptor commitDescriptor;
            TrackedFinding trackedFinding = findingsIndex.getFinding(findingId);
            if (trackedFinding == null) continue;
            String uniformPath = trackedFinding.getLocation().getUniformPath();
            Optional lastRepositoryChange = RepositoryLastChangeUtils.findLastChangeForElement((String)uniformPath, (CommitDescriptor)reportEndCommit, (boolean)true, (ProjectStorageSystem)projectStorageInfo.getProjectStorageSystem(), (Logger)LogManager.getLogger());
            if (lastRepositoryChange.isPresent()) {
                commitDescriptor = ((RepositoryLogEntryAggregate)lastRepositoryChange.get()).getCommit();
            } else {
                CommitDescriptor deathCommit = trackedFinding.getDeathCommit();
                CCSMAssert.isNotNull((Object)deathCommit, (String)("Expecting finding with id:" + findingId + " to be dead"));
                commitDescriptor = new CommitDescriptor(Objects.requireNonNull(deathCommit).getBranchName(), deathCommit.getTimestamp() - 1L);
            }
            countOfCodeLines = TaskDetailSlideRenderer.addTaskSlideCodeSnippetsFromFindings(projectStorageInfo, taskDetailSlideCodeSnippets, trackedFinding, uniformPath, commitDescriptor, snippetCreationTime, countOfCodeLines);
            if (countOfCodeLines > 18) break;
            snippetCreationTime += 1001L;
        }
        return taskDetailSlideCodeSnippets;
    }

    private static int addTaskSlideCodeSnippetsFromFindings(IStorageInfo projectStorageInfo, List<TaskDetailSlide.TaskDetailSlideCodeSnippet> taskDetailSlideCodeSnippets, TrackedFinding trackedFinding, String uniformPath, CommitDescriptor commitDescriptor, long snippetCreationTime, int countOfCodeLines) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)commitDescriptor.getBranchName(), (long)commitDescriptor.getTimestamp());
        FormattedTokenElementInfo tokenElementInfo = ReportUtils.loadSourceCodeForPath(uniformPath, projectStorageInfo, historyAccessOption);
        CCSMAssert.isNotNull((Object)tokenElementInfo, (String)"expected TokenElementInfo for finding '%s' and uniform path '%s' to exist".formatted(trackedFinding.getId(), uniformPath));
        SelfContainedFinding selfContainedFinding = SelfContainedFinding.from((TrackedFinding)trackedFinding, (FormattedTokenElementInfo)tokenElementInfo);
        int findingStartLine = TaskDetailSlideRenderer.determineFindingStartLine(selfContainedFinding);
        int findingEndLine = TaskDetailSlideRenderer.determineFindingEndLine(selfContainedFinding, tokenElementInfo);
        if ((countOfCodeLines += TaskDetailSlideRenderer.getCountOfSnippetLinesToDisplay(findingStartLine, findingEndLine, (List<IToken>)tokenElementInfo.getTokens())) > 18) {
            return countOfCodeLines;
        }
        TextRegionLocation location = new TextRegionLocation(trackedFinding.getLocation().getUniformPath(), -1, -1, findingStartLine, findingEndLine);
        TaskDetailSlide.TaskDetailSlideCodeSnippet taskDetailSlideCodeSnippet = new TaskDetailSlide.TaskDetailSlideCodeSnippet(location, commitDescriptor, Collections.singletonList(trackedFinding.getId()), snippetCreationTime, true, new SelfContainedFinding.FindingContent(tokenElementInfo));
        taskDetailSlideCodeSnippet.addFinding(selfContainedFinding);
        taskDetailSlideCodeSnippets.add(taskDetailSlideCodeSnippet);
        return countOfCodeLines;
    }

    private static int determineFindingStartLine(SelfContainedFinding selfContainedFinding) {
        if (selfContainedFinding.getRawStartLine() != null) {
            return selfContainedFinding.getRawStartLine();
        }
        return 1;
    }

    private static int determineFindingEndLine(SelfContainedFinding selfContainedFinding, FormattedTokenElementInfo tokenElementInfo) {
        if (selfContainedFinding.getRawEndLine() != null && selfContainedFinding.getRawStartLine() != null) {
            return selfContainedFinding.getRawEndLine();
        }
        return Math.min(18, tokenElementInfo.calculateNumberOfLines());
    }

    private static int getCountOfSnippetLinesToDisplay(int findingStartLine, int findingEndLine, List<IToken> tokens) {
        int linesBeforeFinding = Math.min(findingStartLine - 1, 10);
        int findingLines = findingEndLine - findingStartLine + 1;
        int codeFirstLine = 0;
        int codeLastLine = 0;
        if (!tokens.isEmpty()) {
            codeFirstLine = tokens.get(0).getLineNumber();
            codeLastLine = Objects.requireNonNull((IToken)CollectionUtils.getLast(tokens)).getLineNumber();
        }
        int linesAfterFinding = Math.min(codeLastLine - codeFirstLine + 1 - findingEndLine, 10);
        int totalSnippetLines = linesBeforeFinding + findingLines + linesAfterFinding;
        return Math.min(totalSnippetLines, 6);
    }
}

