/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.utils.HistoryUtils;
import com.teamscale.index.commit_alert.CommitAlertIndex;
import com.teamscale.index.repository.RepositoryLogFileHistoryEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.commits.ExtendedRepositoryLogEntry;
import com.teamscale.service.commits.LogEntryResolver;
import com.teamscale.service.commits.RepositoryLogFilter;
import com.teamscale.service.commits.ResourceAndMethodHistoryFilter;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Path(value="api/projects/{project}/{uniformPath}/resource-history")
public class ResourceHistoryService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get resource history", description="Returns repository log file entries for a specific path, i.e. the association between files and repository log entries.", tags={"Project"})
    public List<RepositoryLogFileHistoryEntry> getResourceHistory(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @BeanParam RepositoryLogFilter repositoryLogFilter, @PathParam(value="uniformPath") @ResolveToCodePath UniformPath uniformPath, @Parameter(description="This parameter limits the number of returned entries to the newest ones. If all parameters should be returned, either omit the parameter or use 0 instead.") @DefaultValue(value="0") @QueryParam(value="number-of-entries") int numberOfEntries) throws StorageException {
        ResourceAndMethodHistoryFilter filter = ResourceAndMethodHistoryFilter.createFromFilterParam(repositoryLogFilter, (CommitAlertIndex)this.getProjectStorageSystem().openProjectIndex(CommitAlertIndex.class, null), commit.getBranchName());
        List<RepositoryLogFileHistoryEntry> entries = this.loadEntries(commit, uniformPath);
        Collections.reverse(entries);
        if (filter != null) {
            entries = filter.filterLogFileHistoryEntries(entries, this.resolve(commit).getBranchName(), this.openProjectIndex(RepositoryLogIndex.class, null), this.openProjectIndex(RepositoryLogFileIndex.class, null));
        }
        if (numberOfEntries < 1) {
            return entries;
        }
        int fromIndex = Math.max(0, entries.size() - numberOfEntries);
        return entries.subList(fromIndex, entries.size());
    }

    @GET
    @Path(value="for-review-file")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get resource history for a single file for code reviews", description="Returns repository log file entries for a specific file.", tags={"Project"})
    public List<ExtendedRepositoryLogEntry> getResourceHistoryForCodeReviewFile(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @PathParam(value="uniformPath") @ResolveToCodePath UniformPath uniformPath) throws StorageException {
        List<RepositoryLogFileHistoryEntry> entries = this.loadEntries(commit, uniformPath);
        List<CommitDescriptor> commits = entries.stream().map(CommitAssociatedObjectBase::getCommit).toList();
        if (commits.isEmpty()) {
            return Collections.emptyList();
        }
        List result = this.openProjectIndex(RepositoryLogIndex.class, null).getEntries(commits);
        result.removeIf(Objects::isNull);
        return LogEntryResolver.of(this.serviceInfo).resolveRepositoryLogEntryAggregatesAsAggregatedEntries(result, null);
    }

    private List<RepositoryLogFileHistoryEntry> loadEntries(UnresolvedCommitDescriptor commit, UniformPath uniformPath) throws StorageException {
        CommitDescriptor endCommit = this.resolve(commit);
        IBranchingLayer elementHistoryBranchingLayer = this.openBranchingLayerInProject("elementhistory", ElementHistoryIndex.class);
        List elementHistoryList = HistoryUtils.getEntryHistory((String)uniformPath.toString(), (CommitDescriptor)endCommit, (long)0L, (CommitDescriptorIndex)this.openCommitDescriptorIndex(), (IBranchingLayer)elementHistoryBranchingLayer);
        Collections.reverse(elementHistoryList);
        return this.createRepositoryLogFileEntries(elementHistoryBranchingLayer, uniformPath, elementHistoryList);
    }

    private List<RepositoryLogFileHistoryEntry> createRepositoryLogFileEntries(IBranchingLayer elementHistoryBranchingLayer, UniformPath uniformPath, List<ElementHistoryEntry> elementHistoryList) throws AssertionError, StorageException {
        ArrayList<RepositoryLogFileHistoryEntry> entries = new ArrayList<RepositoryLogFileHistoryEntry>();
        for (int i = elementHistoryList.size() - 1; i >= 0; --i) {
            ElementHistoryEntry elementHistory = elementHistoryList.get(i);
            entries.add(new RepositoryLogFileHistoryEntry(uniformPath, elementHistory));
            if (Objects.requireNonNull(elementHistory.getChangeType()) == EElementHistoryChangeType.ADD) break;
            if (!EElementHistoryChangeType.ORIGIN_CHANGE.contains(elementHistory.getChangeType())) continue;
            uniformPath = UniformPathCompatibilityUtil.convert((String)elementHistory.getOriginPath());
            elementHistoryList = HistoryUtils.getEntryHistory((String)elementHistory.getOriginPath(), (CommitDescriptor)elementHistory.getOriginCommit(), (long)0L, (CommitDescriptorIndex)this.openCommitDescriptorIndex(), (IBranchingLayer)elementHistoryBranchingLayer);
            Collections.reverse(elementHistoryList);
            i = elementHistoryList.size();
        }
        return entries;
    }
}

