/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.index.issue_reference.IssueReferenceIndex;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.resource.EExtendedResourceType;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.SimulinkDataDictionaryIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.code_links.ICodeLinkProvider;
import com.teamscale.index.resource.code_links.IncludeDirectiveLinkProvider;
import com.teamscale.index.resource.code_links.MethodDeclarationLinkProvider;
import com.teamscale.index.resource.code_links.TypeDependencyLinkProvider;
import com.teamscale.index.resource.code_links.VariableDefinitionLinkProvider;
import com.teamscale.index.resource.issue_reference.EIssueReferenceType;
import com.teamscale.index.resource.issue_reference.IssueReference;
import com.teamscale.index.resource.retrieval_strategy.WorkItemHistoryAccessOptionExpander;
import com.teamscale.index.simulink.tracing.SimulinkCodeTraceLinkProvider;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;

public class TokenElementServiceUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<IFactory<ICodeLinkProvider, NeverThrownRuntimeException>> CODE_LINK_PROVIDER_FACTORIES = new ArrayList<IFactory>(Arrays.asList(MethodDeclarationLinkProvider::new, VariableDefinitionLinkProvider::new, TypeDependencyLinkProvider::new, SimulinkCodeTraceLinkProvider::new, IncludeDirectiveLinkProvider::new));

    public static TokenElementInfo retrieveElement(UniformPath uniformPath, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        TokenElementIndex index = ResourceServiceUtils.openContentIndex((String)(uniformPath = uniformPath.resolveToCodePath()).toString(), (HistoryAccessOption)historyAccessOption, (ProjectStorageSystem)projectStorageSystem);
        TokenElementInfo element = index.getTokenElementByPath(uniformPath);
        if (element == null) {
            LOGGER.warn("Content not found for " + String.valueOf(uniformPath) + " (" + String.valueOf(historyAccessOption) + ")");
            return null;
        }
        return element;
    }

    public static @Nullable FormattedTokenElementInfo getFormattedTokenElementInfo(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption, UniformPath uniformPath) throws StorageException {
        TokenElementInfo tokenElementInfo = TokenElementServiceUtils.retrieveElement(uniformPath, projectStorageSystem, historyAccessOption);
        if (tokenElementInfo == null) {
            return null;
        }
        EnumSet extendedResourceTypes = ((ExtendedResourceTypeIndex)projectStorageSystem.openProjectIndex(ExtendedResourceTypeIndex.class, historyAccessOption)).getResourceTypes(uniformPath.toString());
        if (tokenElementInfo.getLanguage() == ELanguage.SIMULINK && ((ExtendedResourceTypeIndex)projectStorageSystem.openProjectIndex(ExtendedResourceTypeIndex.class, historyAccessOption)).getResourceTypes(uniformPath.toString()).contains(EExtendedResourceType.SIMULINK_DATA_DICTIONARY)) {
            return TokenElementServiceUtils.buildFormattedElementForSimulinkDataDictionary(tokenElementInfo, projectStorageSystem, historyAccessOption, extendedResourceTypes);
        }
        tokenElementInfo.getTokens();
        return TokenElementServiceUtils.retrieveElementInfo(tokenElementInfo, projectStorageSystem, historyAccessOption, extendedResourceTypes);
    }

    private static FormattedTokenElementInfo buildFormattedElementForSimulinkDataDictionary(TokenElementInfo tokenElementInfo, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption, EnumSet<EExtendedResourceType> extendedResourceTypes) throws StorageException {
        SimulinkDataDictionary dataDictionary = ((SimulinkDataDictionaryIndex)projectStorageSystem.openProjectIndex(SimulinkDataDictionaryIndex.class, historyAccessOption)).getDataDictionaryByUniformPath(tokenElementInfo.getUniformPath());
        String text = dataDictionary.buildLineBasedRepresentation();
        List tokens = ScannerUtils.getTokens((String)text, (ELanguage)ELanguage.LINE, (String)tokenElementInfo.getUniformPath());
        TokenElementInfo elementWithTokens = new TokenElementInfo(tokenElementInfo.getUniformPath(), ELanguage.LINE, false, text, Collections.emptyList(), (Collection)tokenElementInfo.getDetails(), tokens, Collections.emptyList());
        return new FormattedTokenElementInfo(elementWithTokens, extendedResourceTypes);
    }

    private static FormattedTokenElementInfo retrieveElementInfo(TokenElementInfo elementInfo, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption, EnumSet<EExtendedResourceType> extendedResourceTypes) throws StorageException {
        FormattedTokenElementInfo formattedTokenElement = TokenElementServiceUtils.createFormattedElementInfo(elementInfo, historyAccessOption, projectStorageSystem, extendedResourceTypes);
        IssueReferenceIndex issueReferenceIndex = (IssueReferenceIndex)projectStorageSystem.openProjectIndex(IssueReferenceIndex.class, historyAccessOption);
        List issueReferences = issueReferenceIndex.getIssueReferences(elementInfo.getUniformPath());
        if (issueReferences == null) {
            return formattedTokenElement;
        }
        Map<TeamscaleIssueId, List<IssueReference>> issueReferencesById = TokenElementServiceUtils.getIssueReferencesById(issueReferences);
        ArrayList matchedIssueReferences = new ArrayList();
        for (TeamscaleIssueId matchedIssueReferenceId : TokenElementServiceUtils.getIssueReferenceIds(projectStorageSystem, issueReferences, historyAccessOption)) {
            matchedIssueReferences.addAll(issueReferencesById.get(matchedIssueReferenceId));
        }
        formattedTokenElement.addIssueReferencesIntoFormattedTokens(matchedIssueReferences);
        return formattedTokenElement;
    }

    private static Map<TeamscaleIssueId, List<IssueReference>> getIssueReferencesById(List<IssueReference> issueReferences) {
        HashMap<TeamscaleIssueId, List<IssueReference>> issueReferencesById = new HashMap<TeamscaleIssueId, List<IssueReference>>();
        for (IssueReference issueReference : issueReferences) {
            TeamscaleIssueId issueReferenceId = issueReference.getId();
            List existingIssueReference = issueReferencesById.computeIfAbsent(issueReferenceId, key -> new ArrayList());
            existingIssueReference.add(issueReference);
            issueReferencesById.put(issueReferenceId, existingIssueReference);
        }
        return issueReferencesById;
    }

    private static List<TeamscaleIssueId> getIssueReferenceIds(ProjectStorageSystem projectStorageSystem, List<IssueReference> issueReferences, HistoryAccessOption historyAccessOption) throws StorageException {
        List issueReferenceIds = issueReferences.stream().filter(issueReference -> issueReference.getType() == EIssueReferenceType.ISSUE).map(IssueReference::getId).collect(Collectors.toList());
        Map<String, List<TeamscaleIssueId>> requirementReferenceIdsByConnector = issueReferences.stream().filter(issueReference -> issueReference.getType() == EIssueReferenceType.SPEC_ITEM).map(IssueReference::getId).collect(Collectors.groupingBy(TeamscaleIssueId::getConnectorId));
        IssueIndex issueIndex = (IssueIndex)projectStorageSystem.openProjectIndex(IssueIndex.class, null);
        List<TeamscaleIssueId> allIssuesId = issueIndex.getIssues(issueReferenceIds).stream().filter(Objects::nonNull).map(TeamscaleIssue::getId).collect(Collectors.toList());
        WorkItemHistoryAccessOptionExpander historyAccessOptionExpander = new WorkItemHistoryAccessOptionExpander(projectStorageSystem);
        for (Map.Entry<String, List<TeamscaleIssueId>> entry : requirementReferenceIdsByConnector.entrySet()) {
            String connectorId = entry.getKey();
            HistoryAccessOption specItemHistoryAccessOption = historyAccessOptionExpander.resolveHistoryAccessOptionForConnector(historyAccessOption, connectorId);
            SpecItemIndex specItemIndex = (SpecItemIndex)projectStorageSystem.openProjectIndex(SpecItemIndex.class, specItemHistoryAccessOption);
            allIssuesId.addAll(specItemIndex.getContainedKeys((Collection)entry.getValue()));
        }
        return allIssuesId;
    }

    public static FormattedTokenElementInfo createFormattedElementInfo(TokenElementInfo elementInfo, HistoryAccessOption historyAccessOption, ProjectStorageSystem projectStorage, Set<EExtendedResourceType> extendedResourceTypes) throws StorageException {
        FormattedTokenElementInfo info = new FormattedTokenElementInfo(elementInfo, extendedResourceTypes);
        if (!ShallowParserFactory.supportsLanguage((ELanguage)elementInfo.getLanguage())) {
            return info;
        }
        for (IFactory<ICodeLinkProvider, NeverThrownRuntimeException> factory : CODE_LINK_PROVIDER_FACTORIES) {
            try {
                ((ICodeLinkProvider)factory.create()).registerLinks(info, projectStorage, historyAccessOption);
            }
            catch (Exception e) {
                LOGGER.error("Exception while computing links for file " + elementInfo.getUniformPath(), (Throwable)e);
            }
        }
        return info;
    }
}

