/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.performance.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.performance.PerformanceDetailEntry;
import com.teamscale.core.runtime.api.performance.PerformanceIndexBase;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.system.performance.debug.PerformanceDataDownloadServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/system/performance/debug/trigger/concurrency")
public class TriggerConcurrencyAnalysisService
extends PerformanceDataDownloadServiceBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get a detailed concurrency analysis", description="Allows downloading the detailed trigger performance analysis. The feature toggle -Dcom.teamscale.log_performance_details=true must be enabled.", tags={"Debugging"})
    public String getConcurrencyPerformanceDetails(@Parameter(description="The Analysis States to include, must value from EAnalysisState enum.") @QueryParam(value="state") List<EAnalysisState> states) throws StorageException {
        if (!EFeatureToggle.ENABLE_LOG_PERFORMANCE_DETAILS.isEnabled()) {
            return "The feature toggle -Dcom.teamscale.log_performance_details=true must be enabled.";
        }
        EnumSet<EAnalysisState> statesToInclude = EnumSet.allOf(EAnalysisState.class);
        if (!states.isEmpty()) {
            statesToInclude = EnumSet.copyOf(states);
        }
        return this.createPerformanceAnalysis(statesToInclude);
    }

    private String createPerformanceAnalysis(EnumSet<EAnalysisState> statesToInclude) throws StorageException {
        PairList<PublicProjectId, PerformanceIndexBase> performanceIndexes = this.openPerformanceIndexes();
        ArrayList<PerformanceDetailEntry> allEntries = new ArrayList();
        for (int i = 0; i < performanceIndexes.size(); ++i) {
            allEntries.addAll(((PerformanceIndexBase)performanceIndexes.getSecond(i)).getAllDetails());
        }
        allEntries = CollectionUtils.filter(allEntries, entry -> statesToInclude.contains(entry.getState()));
        HashMap<String, Duration> timeForSingleThreadJobs = new HashMap<String, Duration>();
        HashMap<Integer, Duration> timePerConcurrentJobs = TriggerConcurrencyAnalysisService.calculateTimePerConcurrentJob(allEntries, timeForSingleThreadJobs);
        Duration totalTime = TriggerConcurrencyAnalysisService.calculateTotalRuntime(timePerConcurrentJobs);
        return TriggerConcurrencyAnalysisService.createOutputString(timeForSingleThreadJobs, timePerConcurrentJobs, totalTime);
    }

    private static @NonNull String createOutputString(HashMap<String, Duration> timeForSingleThreadJobs, HashMap<Integer, Duration> timePerConcurrentJobs, Duration totalTime) {
        StringBuilder builder = new StringBuilder();
        builder.append("Time per worker load (Percent of total time, excluding idle):\n");
        for (Map.Entry<Integer, Duration> entry : timePerConcurrentJobs.entrySet()) {
            if (entry.getKey() == 0) continue;
            builder.append(entry.getKey()).append(": ").append(entry.getValue()).append(" (").append(String.format("%2.2f", (double)entry.getValue().toMillis() / (double)totalTime.toMillis() * 100.0)).append("%)\n");
        }
        PairList timePerConcurrentJobsList = PairList.fromMap(timeForSingleThreadJobs);
        timePerConcurrentJobsList.sort(Comparator.comparing(ImmutablePair::getSecond).reversed());
        builder.append("\nTop 10: Time spent by jobs that ran exclusively (Percent of total time, excluding idle):\n");
        for (int i = 0; i < Math.min(10, timePerConcurrentJobsList.size()); ++i) {
            builder.append((String)timePerConcurrentJobsList.getFirst(i)).append(": ").append(timePerConcurrentJobsList.getSecond(i)).append(" (").append(String.format("%2.2f", (double)((Duration)timePerConcurrentJobsList.getSecond(i)).toMillis() / (double)totalTime.toMillis() * 100.0)).append("%)\n");
        }
        return builder.toString();
    }

    private static @NonNull HashMap<Integer, Duration> calculateTimePerConcurrentJob(List<PerformanceDetailEntry> allEntries, HashMap<String, Duration> timeForSingleThreadJobs) {
        Deque<TriggerSpecificWorkerPerformanceData> entriesByStartTime = TriggerConcurrencyAnalysisService.getEntriesByTime(allEntries, PerformanceDetailEntry.WorkerPerformanceData::startTime);
        Deque<TriggerSpecificWorkerPerformanceData> entriesByEndTime = TriggerConcurrencyAnalysisService.getEntriesByTime(allEntries, PerformanceDetailEntry.WorkerPerformanceData::endTime);
        Instant lastEvent = Instant.EPOCH;
        HashSet<String> workersActive = new HashSet<String>();
        HashMap<Integer, Duration> timePerConcurrentJobs = new HashMap<Integer, Duration>();
        while (!entriesByStartTime.isEmpty() || !entriesByEndTime.isEmpty()) {
            if (entriesByStartTime.peek() != null && entriesByEndTime.peek() == null) {
                return timePerConcurrentJobs;
            }
            Instant finalLastEvent = lastEvent;
            if (TriggerConcurrencyAnalysisService.eventIsCompleted(entriesByStartTime, entriesByEndTime)) {
                lastEvent = TriggerConcurrencyAnalysisService.calculateTimeForConcurrentJob(entriesByStartTime, timePerConcurrentJobs, workersActive, finalLastEvent, lastEvent);
                continue;
            }
            TriggerSpecificWorkerPerformanceData newEndedEvent = entriesByEndTime.poll();
            if (newEndedEvent == null) continue;
            TriggerConcurrencyAnalysisService.computeTimeForConcurrentJobs(timePerConcurrentJobs, workersActive, finalLastEvent, newEndedEvent);
            TriggerConcurrencyAnalysisService.computeTimeForSingleThreadJobs(timeForSingleThreadJobs, workersActive, newEndedEvent, finalLastEvent);
            workersActive.remove(newEndedEvent.performanceData().workerId());
            lastEvent = newEndedEvent.performanceData().endTime();
        }
        return timePerConcurrentJobs;
    }

    private static Instant calculateTimeForConcurrentJob(Deque<TriggerSpecificWorkerPerformanceData> entriesByStartTime, HashMap<Integer, Duration> timePerConcurrentJobs, HashSet<String> workersActive, Instant finalLastEvent, Instant lastEvent) {
        TriggerSpecificWorkerPerformanceData performanceData = entriesByStartTime.poll();
        if (performanceData == null) {
            return lastEvent;
        }
        PerformanceDetailEntry.WorkerPerformanceData newStartedEvent = performanceData.performanceData();
        timePerConcurrentJobs.compute(workersActive.size(), (key, value) -> TriggerConcurrencyAnalysisService.calculateDuration(value, finalLastEvent, newStartedEvent));
        workersActive.add(newStartedEvent.workerId());
        return newStartedEvent.startTime();
    }

    private static Duration calculateDuration(Duration value, Instant finalLastEvent, PerformanceDetailEntry.WorkerPerformanceData newStartedEvent) {
        if (value == null) {
            return Duration.ZERO;
        }
        return value.plus(Duration.between(finalLastEvent, newStartedEvent.startTime()));
    }

    private static void computeTimeForConcurrentJobs(HashMap<Integer, Duration> timePerConcurrentJobs, HashSet<String> workersActive, Instant finalLastEvent, TriggerSpecificWorkerPerformanceData newEndedEvent) {
        timePerConcurrentJobs.compute(workersActive.size(), (key, value) -> {
            Duration timeInEvent = Duration.between(finalLastEvent, newEndedEvent.performanceData().endTime());
            if (value == null) {
                return timeInEvent;
            }
            return value.plus(timeInEvent);
        });
    }

    private static void computeTimeForSingleThreadJobs(HashMap<String, Duration> timeForSingleThreadJobs, HashSet<String> workersActive, TriggerSpecificWorkerPerformanceData newEndedEvent, Instant finalLastEvent) {
        if (workersActive.size() == 1) {
            timeForSingleThreadJobs.compute(newEndedEvent.trigger(), (key, value) -> {
                if (value == null) {
                    return newEndedEvent.performanceData().duration();
                }
                return value.plus(Duration.between(finalLastEvent, newEndedEvent.performanceData().endTime()));
            });
        }
    }

    private static boolean eventIsCompleted(Deque<TriggerSpecificWorkerPerformanceData> entriesByStartTime, Deque<TriggerSpecificWorkerPerformanceData> entriesByEndTime) {
        return entriesByStartTime.peek() != null && entriesByEndTime.peek() != null && entriesByStartTime.peek().performanceData().startTime().isBefore(entriesByEndTime.peek().performanceData().endTime());
    }

    private static @NonNull Deque<TriggerSpecificWorkerPerformanceData> getEntriesByTime(List<PerformanceDetailEntry> allEntries, Function<PerformanceDetailEntry.WorkerPerformanceData, Instant> keyExtractor) {
        return allEntries.stream().flatMap(pde -> pde.getWorkerPerformance().map(wp -> new TriggerSpecificWorkerPerformanceData(pde.getTrigger(), (PerformanceDetailEntry.WorkerPerformanceData)wp))).sorted(Comparator.comparing(TriggerSpecificWorkerPerformanceData::performanceData, Comparator.comparing(keyExtractor))).collect(Collectors.toCollection(LinkedList::new));
    }

    private static Duration calculateTotalRuntime(HashMap<Integer, Duration> timePerConcurrentJobs) {
        Duration totalTime = Duration.ZERO;
        for (Map.Entry<Integer, Duration> entry : timePerConcurrentJobs.entrySet()) {
            if (entry.getKey() <= 0) continue;
            totalTime = totalTime.plus(entry.getValue());
        }
        return totalTime;
    }

    private record TriggerSpecificWorkerPerformanceData(String trigger, PerformanceDetailEntry.WorkerPerformanceData performanceData) {
    }
}

