/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.method_history;

import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.testgap.method_history.EMethodChangeType;
import com.teamscale.service.testgap.method_history.MethodHistoryEntry;
import com.teamscale.service.testgap.method_history.UserResolvedMethodHistoryEntry;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.region.OffsetBasedRegion;

public class UserResolvedMethodHistoryEntryBuilder {
    private final CommitDescriptor commit;
    private final String uniformPath;
    private OffsetBasedRegion offsetRegion;
    private final LineBasedRegion lineRegion;
    private final String methodName;
    private RepositoryLogEntry repositoryLog;
    private final EMethodChangeType methodChangeType;
    private String testPartition = null;
    private String originPath = null;
    private String originMethodName = null;
    private CommitDescriptor testOriginCommit = null;
    private final List<MethodHistoryEntry> externBranchMethodHistoryEntries = new ArrayList<MethodHistoryEntry>();

    public UserResolvedMethodHistoryEntryBuilder(CommitDescriptor commit, String uniformPath, OffsetBasedRegion offsetRegion, LineBasedRegion lineRegion, String methodName, @NonNull RepositoryLogEntry repositoryLog, EMethodChangeType methodChangeType) {
        this.commit = commit;
        this.uniformPath = uniformPath;
        this.lineRegion = lineRegion;
        this.methodName = methodName;
        this.repositoryLog = repositoryLog;
        this.methodChangeType = methodChangeType;
        this.offsetRegion = offsetRegion;
    }

    public UserResolvedMethodHistoryEntryBuilder setOriginPath(String originPath) {
        this.originPath = originPath;
        return this;
    }

    public UserResolvedMethodHistoryEntryBuilder setOriginMethodName(String originMethodName) {
        this.originMethodName = originMethodName;
        return this;
    }

    public UserResolvedMethodHistoryEntryBuilder setTestPartition(String testPartition) {
        this.testPartition = testPartition;
        return this;
    }

    public UserResolvedMethodHistoryEntryBuilder setTestOriginCommit(CommitDescriptor testOriginCommit) {
        this.testOriginCommit = testOriginCommit;
        return this;
    }

    public UserResolvedMethodHistoryEntryBuilder addExternBranchMethodHistoryEntry(MethodHistoryEntry externBranchMethodHistoryEntries) {
        this.externBranchMethodHistoryEntries.add(externBranchMethodHistoryEntries);
        return this;
    }

    public UserResolvedMethodHistoryEntry build(UserAliasLookup userAliasLookup) {
        return new UserResolvedMethodHistoryEntry(this.commit, this.uniformPath, this.offsetRegion, this.lineRegion, this.methodName, this.repositoryLog, this.methodChangeType, this.originPath, this.originMethodName, this.testPartition, this.testOriginCommit, this.externBranchMethodHistoryEntries, userAliasLookup);
    }
}

