/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.information_retrieval;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.FirstLastCommit;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndexCache;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import com.teamscale.index.testgap.query.TgaIssueRequest;
import com.teamscale.index.testgap.query.TgaPathRequest;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import com.teamscale.index.testimpact.TestLinks;
import com.teamscale.index.testimpact.TestLinksIndex;
import com.teamscale.index.tests.TestHistoryEntry;
import com.teamscale.index.tests.information_retrieval.PathTermFrequencyIndex;
import com.teamscale.index.tests.information_retrieval.TermPathFrequencyIndex;
import com.teamscale.index.tests.information_retrieval.TokenTermExtractor;
import com.teamscale.index.tests.information_retrieval.data.Term;
import com.teamscale.index.tests.information_retrieval.data.TermFrequencies;
import com.teamscale.service.IteratorStreaming;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.testimpact.information_retrieval.IRelatedTestSearchService;
import com.teamscale.service.testimpact.information_retrieval.ITfIdfGroundTruth;
import com.teamscale.service.testimpact.information_retrieval.RelatedTestsRequestOptions;
import com.teamscale.service.testimpact.information_retrieval.RelatedTestsResult;
import com.teamscale.service.testimpact.information_retrieval.scoring.IScoringOperator;
import com.teamscale.service.testimpact.information_retrieval.scoring.ScoringOperatorFactory;
import com.teamscale.service.tests.TestQueryUtils;
import com.teamscale.wia.TeamscaleIssueId;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.StorageIterators;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.util.IStringAbbreviator;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.eclipse.jgit.util.StringUtils;

@Path(value="api/projects/{project}/tests/related-to")
public class RelatedTestSearchService
extends ApiBase
implements IRelatedTestSearchService {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public RelatedTestsResult getRelatedTests(RelatedTestsRequestOptions relatedTestsRequestOptions) throws StorageException {
        RelatedTestSearchService.assertFeatureToggleEnabled();
        this.ensureCommitProcessed(relatedTestsRequestOptions);
        HistoryAccessOption endPointInHistory = this.determineHistoryOption(relatedTestsRequestOptions.endCommit);
        PathTermFrequencyIndex pathTermFrequencyIndex = this.openProjectIndex(PathTermFrequencyIndex.class, endPointInHistory);
        boolean considerAllTests = StringUtils.isEmptyOrNull((String)relatedTestsRequestOptions.query);
        List<UniformPath> testsToRank = this.queryTestImplementationsToRank(relatedTestsRequestOptions.query, relatedTestsRequestOptions.endCommit);
        CounterSet<Term> changeRequestTerms = this.getChangeRequestTerms(relatedTestsRequestOptions, pathTermFrequencyIndex);
        ITfIdfGroundTruth groundTruth = this.getTestInformationRetriever(testsToRank, endPointInHistory, considerAllTests, changeRequestTerms);
        IScoringOperator scoringOperator = ScoringOperatorFactory.createScoringOperator(relatedTestsRequestOptions.scoringOperator, groundTruth, changeRequestTerms, relatedTestsRequestOptions.provideTopContributingTerms);
        List<IRelatedTestSearchService.TestMatchingScore> scored = this.scoreTestsForChangeRequest(testsToRank, changeRequestTerms, endPointInHistory, scoringOperator);
        scored.sort(Comparator.comparing(IRelatedTestSearchService.TestMatchingScore::score).reversed());
        CounterSet queryTerms = pathTermFrequencyIndex.unabbreviateBagOfWords(changeRequestTerms);
        List scoredLimited = CollectionUtils.limitList((Integer)relatedTestsRequestOptions.limit, scored);
        return new RelatedTestsResult(scoredLimited, scored.size(), (Set<String>)queryTerms.getKeys());
    }

    private void ensureCommitProcessed(RelatedTestsRequestOptions relatedTestsRequestOptions) throws StorageException {
        this.ensureCommitIsProcessed(relatedTestsRequestOptions.ensureProcessed && relatedTestsRequestOptions.endCommit.getBranchName() != null, relatedTestsRequestOptions.endCommit);
    }

    private static void assertFeatureToggleEnabled() {
        if (!EFeatureToggle.INDEX_TEST_IMPLEMENTATIONS_FOR_TEST_SELECTION.isEnabled()) {
            throw new BadRequestException(String.format("The service has not been enabled. Please set the feature toggle '%s' to true to use the service.", EFeatureToggle.INDEX_TEST_IMPLEMENTATIONS_FOR_TEST_SELECTION.getId()));
        }
    }

    @Override
    public Response getRelatedTestsCsv(RelatedTestsRequestOptions relatedTestsRequestOptions) throws StorageException {
        RelatedTestSearchService.assertFeatureToggleEnabled();
        this.ensureCommitIsProcessed(relatedTestsRequestOptions.ensureProcessed, relatedTestsRequestOptions.endCommit);
        DecimalFormat decimalFormat = RelatedTestSearchService.getScoreDecimalFormat();
        RelatedTestsResult relatedTests = this.getRelatedTests(relatedTestsRequestOptions);
        return Response.ok((Object)IteratorStreaming.createCsvStreamFromStorageIterator(new String[]{"Test Path", "Score", "Explanation"}, match -> new String[]{match.uniformPath().getPathSegmentsString(), decimalFormat.format(match.score()), match.matchExplanation()}, StorageIterators.asStorageIterator(relatedTests.matchingTestImplementations()))).build();
    }

    private static DecimalFormat getScoreDecimalFormat() {
        DecimalFormat decimalFormat = new DecimalFormat("###0.00");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return decimalFormat;
    }

    private CounterSet<Term> getChangeRequestTerms(RelatedTestsRequestOptions requestOptions, PathTermFrequencyIndex pathTermFrequencyIndex) throws StorageException {
        Map<CommitDescriptor, Collection<MethodLocation>> methodsWithChangesPerCommit = this.identifyChangedMethodLocations(requestOptions);
        CounterSet counterSet = new CounterSet();
        for (Map.Entry<CommitDescriptor, Collection<MethodLocation>> entry : methodsWithChangesPerCommit.entrySet()) {
            HistoryAccessOption commitPointInTime = HistoryAccessOption.readCommit((CommitDescriptor)entry.getKey());
            Collection<MethodLocation> methodsWithChanges = entry.getValue();
            List<String> uniformPaths = methodsWithChanges.stream().map(MethodLocation::getUniformPath).distinct().toList();
            TokenElementIndex tokenElementIndex = TokenElementIndex.open((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)commitPointInTime);
            Map pathToTokenElements = tokenElementIndex.getTokenElementsByUniformPath(uniformPaths);
            for (MethodLocation method : methodsWithChanges) {
                TokenElementInfo fileTokenElement = (TokenElementInfo)pathToTokenElements.get(method.getUniformPath());
                if (fileTokenElement == null) {
                    LOGGER.warn("Could not find token element for uniform path " + method.getUniformPath());
                    continue;
                }
                CounterSet<String> methodBagOfWords = RelatedTestSearchService.getMethodBagOfWords(method, fileTokenElement);
                CounterSet importBagOfWords = TokenTermExtractor.getContextBagOfWords((TokenElementInfo)fileTokenElement, (OffsetBasedRegion)method.getRegion());
                counterSet = counterSet.newJoinedWith(new CounterSet[]{methodBagOfWords, importBagOfWords});
            }
        }
        return pathTermFrequencyIndex.abbreviateToBagOfWords(counterSet);
    }

    private static CounterSet<String> getMethodBagOfWords(MethodLocation method, TokenElementInfo fileTokenElement) {
        List methodTokens = TokenStreamUtils.getTokensBetween((List)fileTokenElement.getRawTokens(), (int)method.getRegion().getStart(), (int)method.getRegion().getEnd());
        return new CounterSet((Collection)TokenTermExtractor.extractContentAsList((List)methodTokens));
    }

    private List<UniformPath> queryTestImplementationsToRank(@Nullable String query, UnresolvedCommitDescriptor endCommit) throws StorageException {
        CommitDescriptor endCommitResolved = this.resolve(endCommit);
        List<TestHistoryEntry> testHistoryEntries = TestQueryUtils.getTestHistoryEntries(query, false, false, endCommitResolved, this.serviceInfo);
        List uniformPathStrings = CollectionUtils.map(testHistoryEntries, TestHistoryEntry::getUniformPath);
        TestLinksIndex testLinksIndex = this.openProjectIndex(TestLinksIndex.class, this.determineHistoryOption(endCommit));
        List pathTestLinks = testLinksIndex.getTestLinks(uniformPathStrings, false);
        return pathTestLinks.stream().map(TestLinks::getTestImplementation).filter(Objects::nonNull).map(UniformPathCompatibilityUtil::convert).toList();
    }

    private List<IRelatedTestSearchService.TestMatchingScore> scoreTestsForChangeRequest(List<UniformPath> testImplementationPaths, CounterSet<Term> changeRequestTerms, HistoryAccessOption historyOptions, IScoringOperator scoringOperator) throws StorageException {
        List<@Nullable CounterSet<Term>> testBagsOfWords = this.getBagsOfWords(testImplementationPaths, historyOptions);
        ArrayList<IRelatedTestSearchService.TestMatchingScore> result = new ArrayList<IRelatedTestSearchService.TestMatchingScore>();
        for (int i = 0; i < testImplementationPaths.size(); ++i) {
            UniformPath testPath = testImplementationPaths.get(i);
            @Nullable CounterSet testBag = testBagsOfWords.get(i);
            if (testBag == null) {
                testBag = CounterSet.empty();
            }
            double score = scoringOperator.score(testPath, changeRequestTerms, (CounterSet<Term>)testBag);
            SequencedMap<Term, Double> topContributors = scoringOperator.getTopContributingTerms();
            if (!(score > 0.0)) continue;
            result.add(new IRelatedTestSearchService.TestMatchingScore(testPath, score, TermFrequencies.getExpansionOf(topContributors, (IStringAbbreviator)new StorageStringAbbreviator(this.getProjectStorageSystem().getAbbreviator())).toString()));
        }
        return result;
    }

    private List<@Nullable CounterSet<Term>> getBagsOfWords(List<UniformPath> testImplementationPaths, HistoryAccessOption historyOptions) throws StorageException {
        PathTermFrequencyIndex pathTermFrequencyIndex = this.openProjectIndex(PathTermFrequencyIndex.class, historyOptions);
        return pathTermFrequencyIndex.getBagsOfWords(testImplementationPaths);
    }

    private ITfIdfGroundTruth getTestInformationRetriever(final List<UniformPath> testImplementationPaths, HistoryAccessOption historyOptions, boolean consideringAllTests, CounterSet<Term> changeRequestTerms) throws StorageException {
        TermPathFrequencyIndex termPathFrequencyIndex = this.openProjectIndex(TermPathFrequencyIndex.class, historyOptions);
        PathTermFrequencyIndex pathTermFrequencyIndex = this.openProjectIndex(PathTermFrequencyIndex.class, historyOptions);
        @Nullable Set<UniformPath> testImplementationPathSet = consideringAllTests ? null : Set.copyOf(testImplementationPaths);
        final double averageDocumentLength = pathTermFrequencyIndex.getAverageTermInstanceCount(testImplementationPathSet);
        final CounterSet numberOfPathsIncludingTerm = termPathFrequencyIndex.getNumberOfPathsIncludingTerms((Set)changeRequestTerms.getKeys(), testImplementationPathSet);
        return new ITfIdfGroundTruth(){

            @Override
            public int totalNumberOfDocuments() {
                return testImplementationPaths.size();
            }

            @Override
            public int getNumberOfDocumentsContaining(Term term) {
                return numberOfPathsIncludingTerm.getValue((Object)term);
            }

            @Override
            public double getAverageDocumentLength() {
                return averageDocumentLength;
            }
        };
    }

    private Map<CommitDescriptor, Collection<MethodLocation>> identifyChangedMethodLocations(RelatedTestsRequestOptions requestOptions) throws StorageException {
        LinkedHashMap<CommitDescriptor, Collection<MethodLocation>> result = new LinkedHashMap<CommitDescriptor, Collection<MethodLocation>>();
        if (requestOptions.baselineCommit != null) {
            CommitDescriptor endCommit = this.resolve(requestOptions.endCommit);
            Collection branchLocations = result.computeIfAbsent(endCommit, branchName -> new LinkedHashSet());
            branchLocations.addAll(this.identifyChangedMethodLocationsForBaseline(requestOptions.baselineCommit, requestOptions.endCommit));
        }
        if (requestOptions.issueId != null) {
            Pair<CommitDescriptor, Collection<MethodLocation>> issueChanges = this.identifyChangedMethodLocationsForIssue(TeamscaleIssueId.fromInternalId((String)requestOptions.issueId), requestOptions.endCommit);
            result.put((CommitDescriptor)issueChanges.getFirst(), new LinkedHashSet((Collection)issueChanges.getSecond()));
        }
        return result;
    }

    private Pair<CommitDescriptor, Collection<MethodLocation>> identifyChangedMethodLocationsForIssue(TeamscaleIssueId issueId, UnresolvedCommitDescriptor endCommit) throws StorageException {
        CommitDescriptor resolvedEndCommit = this.resolve(endCommit);
        RepositoryCommitIssueMappingIndexCache mappingIndexCache = TgaRequestUtils.createAndPreloadIssueMappingCache(List.of(issueId), (CommitResolvingStorageSystem)this.serviceInfo.getProjectStorageSystem());
        FirstLastCommit issueFirstAndLastCommit = mappingIndexCache.getValue(issueId);
        if (issueFirstAndLastCommit == null) {
            return Pair.createPair((Object)resolvedEndCommit, List.of());
        }
        CommitDescriptor lastIssueCommit = issueFirstAndLastCommit.lastCommit;
        IssueTgaParameters tgaParams = new IssueTgaParameters(false, lastIssueCommit.getBranchName(), false);
        TgaIssueRequest tgaIssueRequest = TgaIssueRequest.createRequest((TeamscaleIssueId)issueId, (CoverageSourceParameterBase)CoverageSourceQueryParameters.NO_PARTITIONS, (IssueTgaParameters)tgaParams, (ETgaAssessmentType)ETgaAssessmentType.CHURN, (long)resolvedEndCommit.getTimestamp(), (IProjectId)this.serviceInfo.getPrimaryPublicId(), (IndexLayer)this.getIndexLayer(), (RepositoryCommitIssueMappingIndexCache)mappingIndexCache);
        List changedMethods = tgaIssueRequest.fetchAndAssessData(MethodInfoFilter.INCLUDE_NON_TRIVIAL_AND_TESTS).getChangedMethods(false);
        return Pair.createPair((Object)lastIssueCommit, changedMethods.stream().map(AssessedTgaData.AssessedMethodData::getLocation).toList());
    }

    private Collection<MethodLocation> identifyChangedMethodLocationsForBaseline(UnresolvedCommitDescriptor baselineCommit, UnresolvedCommitDescriptor endCommit) throws StorageException {
        CoverageSourceQueryParameters coverageSource = new CoverageSourceQueryParameters(List.of(), List.of(), false);
        TimeIntervalBasedServiceQueryOptions timeInterval = new TimeIntervalBasedServiceQueryOptions(endCommit, baselineCommit);
        TgaRequestQueryOptions tgaParams = new TgaRequestQueryOptions();
        CommitDescriptor resolvedEndCommit = this.resolve(endCommit);
        TgaPathRequest tgaPathRequest = TgaPathRequest.createRequest((CommitDescriptor)resolvedEndCommit, (CoverageSourceParameterBase)coverageSource, (TimeIntervalBasedServiceQueryOptions)timeInterval, (TgaRequestQueryOptions)tgaParams, (ETgaAssessmentType)ETgaAssessmentType.CHURN, (IndexLayer)this.getIndexLayer(), (IProjectId)this.serviceInfo.getPrimaryPublicId());
        List changedMethods = tgaPathRequest.fetchAndAssessData(MethodInfoFilter.INCLUDE_NON_TRIVIAL_AND_TESTS).getChangedMethods(false);
        return changedMethods.stream().map(AssessedTgaData.AssessedMethodData::getLocation).toList();
    }
}

