/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.upload;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.LegacyApiUtils;
import com.teamscale.service.framework.versioning.LegacyApi;
import com.teamscale.service.upload.ExternalReportUploadService;
import com.teamscale.service.upload.base.LegacyExternalReportUploadServiceUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

@Hidden
@LegacyApi
@Path(value="p/{project}/external-report")
public class LegacyExternalReportUploadService
extends ApiBase {
    @Context
    private UriInfo uri;
    @Context
    private ResourceContext resourceContext;

    @POST
    @Operation(summary="Upload report", description="Imports external analysis data.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="400", description="No session with provided id found."), @ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="400", description="Provided partition name is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Provided upload message is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="Upload format is not supported by Teamscale."), @ApiResponse(responseCode="400", description="Upload format is not supported for upload."), @ApiResponse(responseCode="400", description="No reports provided via the report multi-part form data parameter")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Consumes(value={"multipart/form-data"})
    public Response uploadReportWithQueryParams(@RequestBody(required=true) FormDataMultiPart multiPart) throws Exception {
        Map<String, String> parameters = LegacyExternalReportUploadServiceUtils.mergeParameters(this.uri, multiPart);
        String sessionId = LegacyExternalReportUploadService.getSessionId(parameters);
        return LegacyApiUtils.apiCallWithSuccess(ExternalReportUploadService.class, (ResourceContext)this.resourceContext, resource -> resource.uploadReport(sessionId, LegacyExternalReportUploadServiceUtils.toExternalReportUploadServiceQueryOptionsObject(parameters), LegacyExternalReportUploadService.filterBodyParts(multiPart, "report")), (LegacyApiUtils.ExceptionWrapper[])new LegacyApiUtils.ExceptionWrapper[]{LegacyExternalReportUploadServiceUtils.notFoundToBadRequestUnlessUnknownSession(), LegacyExternalReportUploadServiceUtils.closedSessionToInternalServerError()});
    }

    private static String getSessionId(Map<String, String> parameters) {
        String sessionId = parameters.get("session");
        if (sessionId == null) {
            sessionId = "auto-create";
        }
        return sessionId;
    }
}

