/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.upload.base;

import com.teamscale.index.testgap.dotnet.DotNetVersionIndex;
import jakarta.ws.rs.BadRequestException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

public class ExternalUploadServiceUtils {
    public static final String VERSION_PARAMETER_NAME = "version";
    public static final String VERSION_PARAMETER_DESCRIPTION = "The parameter that contains the program version to which the uploaded coverage belongs.";
    public static final String UNKNOWN_VERSION_PARAMETER_ERROR = "The provided program version is not known to Teamscale.";
    public static final String REPORT_PARAMETER_NAME = "report";
    public static final String NO_REPORTS_PROVIDED_ERROR = "No reports provided via the report multi-part form data parameter";
    public static final String NO_REVISION_PROVIDED_ERROR = "Empty revision provided. Please specify a valid revision.";

    public static CommitDescriptor getCommitDescriptorFromVersionIndex(DotNetVersionIndex versionIndex, String version) throws StorageException {
        CommitDescriptor commit = versionIndex.getVersionCommit(version);
        if (commit == null) {
            throw new BadRequestException("The given program version '" + version + "' is not known to Teamscale!");
        }
        return commit;
    }

    public static HistoryAccessOption getAccessOptionForDefaultBranch(CommitDescriptor commit) {
        return HistoryAccessOption.readCommit((CommitDescriptor)commit);
    }
}

