/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.sourcecode.coverage.TestUniformPathUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@IndexValueClass(containedInBackup=true)
public class PartitionAndPath
implements Serializable,
Comparable<PartitionAndPath> {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="partition")
    private final String partition;
    @JsonProperty(value="uniformPath")
    private final String uniformPath;

    @JsonCreator
    public PartitionAndPath(@JsonProperty(value="partition") String partition, @JsonProperty(value="uniformPath") String uniformPath) {
        this.partition = partition;
        this.uniformPath = uniformPath;
    }

    public PartitionAndPath(String partition, UniformPath uniformPath) {
        this(partition, uniformPath.toString());
    }

    public PartitionAndPath(Pair<String, String> partitionAndPath) {
        this((String)partitionAndPath.getFirst(), (String)partitionAndPath.getSecond());
    }

    public static PartitionAndPath forCoverageUnit(String partition, String uniformPath) {
        TestUniformPathUtils.assertIsCoverageUnitPath((String)uniformPath);
        return new PartitionAndPath(partition, uniformPath);
    }

    public String getPartition() {
        return this.partition;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public UniformPath toUniformPath() {
        return UniformPathCompatibilityUtil.convert((String)this.uniformPath);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.uniformPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionAndPath that = (PartitionAndPath)o;
        return Objects.equals(this.partition, that.partition) && Objects.equals(this.uniformPath, that.uniformPath);
    }

    public String toString() {
        return this.partition + " " + this.uniformPath;
    }

    @Override
    public int compareTo(@NonNull PartitionAndPath other) {
        return Comparator.comparing(PartitionAndPath::getPartition).thenComparing(PartitionAndPath::getUniformPath).compare(this, other);
    }
}

