/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.js_export.NotExported;

@ExportToTypeScript
public enum EKeyedObjectType {
    STRING,
    NUMBER,
    DATE,
    STRING_LIST,
    NUMBER_LIST,
    STRING_MAP,
    NUMBER_MAP;

    @NotExported
    private final byte[] binaryRepresentation = new byte[]{(byte)this.ordinal()};

    public byte[] getBinaryRepresentation() {
        return this.binaryRepresentation;
    }

    public static EKeyedObjectType fromBinaryRepresentation(byte[] value) {
        return EKeyedObjectType.values()[value[0]];
    }

    public static String collectionToListString(Collection<String> items) {
        return String.join((CharSequence)",", items);
    }

    public static <T> String mapToMapString(Map<String, T> map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=" + e.getValue().toString()).collect(Collectors.joining(","));
    }
}

