/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.RunnableWithException;

public interface IStore
extends ILockProvider {
    public byte @Nullable [] get(byte @NonNull [] var1) throws StorageException;

    public List<byte @Nullable []> get(List<byte @NonNull []> var1) throws StorageException;

    public void put(byte @NonNull [] var1, byte @NonNull [] var2) throws StorageException;

    public void put(PairList<byte @NonNull [], byte @NonNull []> var1) throws StorageException;

    public void remove(byte @NonNull [] var1) throws StorageException;

    public void remove(List<byte @NonNull []> var1) throws StorageException;

    public void removeByPrefix(byte @NonNull [] var1) throws StorageException;

    public void scan(byte @NonNull [] var1, byte @Nullable [] var2, IKeyValueCallback var3) throws StorageException;

    public void scan(byte @NonNull [] var1, IKeyValueCallback var2) throws StorageException;

    public void scan(List<byte @NonNull []> var1, List<? extends IKeyValueCallback> var2) throws StorageException;

    default public void scan(List<byte @NonNull []> prefixes, IKeyValueCallback callback) throws StorageException {
        this.scan(prefixes, Collections.nCopies(prefixes.size(), callback));
    }

    public void scanKeys(byte @Nullable [] var1, byte @Nullable [] var2, IKeyValueCallback var3) throws StorageException;

    public void scanKeys(byte @NonNull [] var1, IKeyValueCallback var2) throws StorageException;

    public void scanKeys(List<byte @NonNull []> var1, List<? extends IKeyValueCallback> var2) throws StorageException;

    default public void scanKeys(List<byte @NonNull []> prefixes, IKeyValueCallback callback) throws StorageException {
        this.scanKeys(prefixes, Collections.nCopies(prefixes.size(), callback));
    }

    @Override
    public Lock obtainLock(String var1);

    default public void performWithLock(RunnableWithException<StorageException> lockAction) throws StorageException {
        String lockNameSuffix = "perform-with-lock";
        this.performWithLock(lockAction, lockNameSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void performWithLock(RunnableWithException<StorageException> lockAction, String lockNameSuffix) throws StorageException {
        Lock lock = this.obtainLock(lockNameSuffix);
        lock.lock();
        try {
            lockAction.run();
        }
        finally {
            lock.unlock();
        }
    }

    public <T extends IStoreCapability> Optional<T> getCapability(Class<T> var1);
}

