/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.branched;

import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.BranchCommitInfoBasedBranchingLayerBase;
import org.conqat.engine.persistence.store.branched.BranchCommitInsertingStore;
import org.conqat.engine.persistence.store.branched.BranchCommitReadingStore;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

public class CommitLayeringBranchingLayer
extends BranchCommitInfoBasedBranchingLayerBase {
    public CommitLayeringBranchingLayer(IStore store, ICommitLayeringDataLayout dataLayout) {
        super(store, dataLayout);
    }

    @Override
    protected IStore createReadingStore(byte[] commitName) throws StorageException {
        return new BranchCommitReadingStore(this.store, this.dataLayout, commitName);
    }

    @Override
    protected IStore createWritingStore(byte[] commitName, byte[] parentCommitName) throws StorageException {
        return new BranchCommitInsertingStore(this.store, this.dataLayout, commitName, parentCommitName);
    }

    @Override
    public void deleteCommit(byte[] commitKey) throws StorageException {
        IBranchCommitInfo commitInfo = this.dataLayout.deserializeCommitInfo(this.store.get(commitKey));
        this.store.remove(commitKey);
        this.store.removeByPrefix(this.dataLayout.createCommitEntryKey(Objects.requireNonNull(commitInfo).getCommitNameForDataKeys(), null));
    }

    public BranchCommitReadingStore createExactCommitReadingStore(byte[] commitName) throws StorageException {
        return (BranchCommitReadingStore)this.createReadingStore(commitName);
    }

    public void recalculateHeadCommitPointers() throws StorageException {
        List<byte[]> allHeadKeys = this.getHeadKeys(this.store);
        for (byte[] headKey : allHeadKeys) {
            String branch = this.dataLayout.extractBranchNameFromHeadKey(headKey);
            this.recalculateHeadCommitPointer(branch);
        }
    }

    private void batchResolveDeduplicationReferences(List<byte[]> values) throws StorageException {
        ArrayList<byte[]> deduplicationKeys = new ArrayList<byte[]>();
        ArrayList<Integer> deduplicationIndexes = new ArrayList<Integer>();
        for (int i = 0; i < values.size(); ++i) {
            if (BranchCommitReadingStore.isActualValueOrTombStone(values.get(i))) continue;
            deduplicationIndexes.add(i);
            deduplicationKeys.add(this.dataLayout.createDataKey(values.get(i)));
        }
        if (!deduplicationIndexes.isEmpty()) {
            List<byte[]> deduplicatedValues = this.store.get(deduplicationKeys);
            for (int i = 0; i < deduplicationIndexes.size(); ++i) {
                values.set((Integer)deduplicationIndexes.get(i), deduplicatedValues.get(i));
            }
        }
    }

    public static byte[] createReferenceKey(byte[] value) {
        byte[] result = new byte[20];
        Hashing.murmur3_128().hashBytes(value).writeBytesTo(result, 0, 20);
        System.arraycopy(value, 0, result, 16, 4);
        return result;
    }

    @Override
    public List<byte[]> getValues(PairList<String, Long> allBranchNamesAndTimestamps, byte[] key) throws StorageException {
        ArrayList<byte[]> commitInfoKeys = new ArrayList<byte[]>(allBranchNamesAndTimestamps.size());
        for (int i = 0; i < allBranchNamesAndTimestamps.size(); ++i) {
            byte[] commitName = CommitLayeringBranchingLayer.createCommitName((String)allBranchNamesAndTimestamps.getFirst(i), (Long)allBranchNamesAndTimestamps.getSecond(i));
            commitInfoKeys.add(this.dataLayout.createCommitInfoKey(commitName));
        }
        List<byte[]> commitInfoData = this.store.get(commitInfoKeys);
        List commitInfos = CollectionUtils.mapWithException(commitInfoData, this.dataLayout::deserializeCommitInfo);
        List commitEntryKeys = CollectionUtils.map((Collection)commitInfos, info -> {
            if (info == null) {
                return new byte[0];
            }
            return this.dataLayout.createCommitEntryKey(info.getCommitNameForDataKeys(), key);
        });
        List<byte[]> values = this.store.get(commitEntryKeys);
        this.batchResolveDeduplicationReferences(values);
        return values;
    }

    public List<byte[]> getCommitKeys() throws StorageException {
        return StorageUtils.listKeysStartingWith(this.dataLayout.createCommitInfoKey(new byte[0]), this.store);
    }

    @Override
    public long removeOrphanedDataEntries(ICancelable cancelable) throws StorageException, ExecutionCanceledException {
        Set<ByteArrayWrapper> dataReferencesToRemove = Collections.synchronizedSet(new HashSet());
        this.store.scanKeys(this.dataLayout.createDataKey(new byte[0]), (key, value) -> {
            byte[] referenceHash = this.dataLayout.extractReferenceHash(key);
            dataReferencesToRemove.add(new ByteArrayWrapper(referenceHash));
        });
        cancelable.verifyNotCanceled();
        this.dataLayout.scanAllCommitEntries(this.store, (key, value) -> {
            if (!BranchCommitReadingStore.isActualValueOrTombStone(value)) {
                dataReferencesToRemove.remove(new ByteArrayWrapper(value));
            }
        }, true);
        cancelable.verifyNotCanceled();
        this.store.remove(this.convertToDataKeys(dataReferencesToRemove));
        return dataReferencesToRemove.size();
    }

    private List<byte[]> convertToDataKeys(Set<ByteArrayWrapper> dataReferences) {
        ArrayList<byte[]> results = new ArrayList<byte[]>();
        for (ByteArrayWrapper dataReference : dataReferences) {
            results.add(this.dataLayout.createDataKey(dataReference.getBytes()));
        }
        return results;
    }

    @Override
    public void scanAllKeysInAllCommits(Consumer<byte[]> keyConsumer) throws StorageException {
        this.dataLayout.scanAllCommitEntries(this.store, (key, unused) -> keyConsumer.accept(this.dataLayout.extractUnderlyingKeyFromCommitEntryKey(key)), false);
    }
}

