/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.sharded;

import com.google.common.base.Preconditions;
import java.io.File;
import org.conqat.engine.persistence.store.sharded.IShardingStrategy;

public class RandomizedShardingStrategy
implements IShardingStrategy {
    private final int shardCount;
    private final File baseDirectory;

    public RandomizedShardingStrategy(int shardCount, File baseDirectory) {
        Preconditions.checkArgument((shardCount > 0 ? 1 : 0) != 0, (Object)"Shard count must be positive!");
        this.shardCount = shardCount;
        this.baseDirectory = baseDirectory;
    }

    @Override
    public int getShardCount() {
        return this.shardCount;
    }

    @Override
    public File getShardDirectory(int index) {
        return new File(this.baseDirectory, "shard-" + index);
    }

    @Override
    public int getShardIndexForStorageSystemName(String storageSystemName) {
        return Math.abs(storageSystemName.hashCode()) % this.shardCount;
    }
}

