/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Policy;
import io.prometheus.metrics.core.metrics.Counter;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import io.prometheus.metrics.model.snapshots.Unit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.locks.Lock;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.monitoring.PrometheusAwareStatsCounter;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.engine.persistence.store.util.StorageAbbreviation;
import org.conqat.engine.persistence.store.util.StorageAbbreviationList;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;

public class StorageAbbreviator
implements IStorageAbbreviator {
    private static final String STRING_ABBREVIATOR_CACHE_SIZE_PARAMETER = "com.teamscale.persistence.string-abbreviation-cache-mb";
    private static final Counter PROMETHEUS_CACHE_USAGE = (Counter)((Counter.Builder)((Counter.Builder)Counter.builder().name("string_abbreviator_cache").help("Metrics on string abbreviator cache usage.")).labelNames(new String[]{"type"})).register();
    public static final String STRING_ABBREVIATION_INDEX_NAME = "string-abbreviation";
    private static final byte[] ID_COUNTER_KEY = new byte[]{0};
    private static final int DEFAULT_ABBREVIATOR_CACHE_SIZE_MB = 200;
    public static final long MAXIMUM_CACHE_SIZE_BYTES = ByteUnit.MEBIBYTES.toBytes((long)Integer.getInteger("com.teamscale.persistence.string-abbreviation-cache-mb", 200).intValue());
    private static final Cache<Long, String> ID_TO_STRING_CACHE = Caffeine.newBuilder().maximumWeight(MAXIMUM_CACHE_SIZE_BYTES / 2L).weigher((id, string) -> 8 + 2 * string.length() + 16).recordStats(() -> PrometheusAwareStatsCounter.of(PROMETHEUS_CACHE_USAGE)).build();
    private static final Cache<StringWithStorageSystemId, StorageAbbreviation> STRING_TO_ID_CACHE = Caffeine.newBuilder().maximumWeight(MAXIMUM_CACHE_SIZE_BYTES / 2L).weigher((stringWithId, id) -> stringWithId.weight() + 4 + 16).recordStats(() -> PrometheusAwareStatsCounter.of(PROMETHEUS_CACHE_USAGE)).build();
    private final IStorageSystem storageSystem;
    private IStore store = null;

    public StorageAbbreviator(IStorageSystem storageSystem) {
        this.storageSystem = storageSystem;
    }

    public static long getCacheHits() {
        return ID_TO_STRING_CACHE.stats().hitCount() + STRING_TO_ID_CACHE.stats().hitCount();
    }

    public static long getCacheMisses() {
        return ID_TO_STRING_CACHE.stats().missCount() + STRING_TO_ID_CACHE.stats().missCount();
    }

    public static long getEstimatedCacheSizeInBytes() {
        return StorageAbbreviator.getEstimatedCacheSizeInBytes(ID_TO_STRING_CACHE) + StorageAbbreviator.getEstimatedCacheSizeInBytes(STRING_TO_ID_CACHE);
    }

    private static long getEstimatedCacheSizeInBytes(Cache<?, ?> cache) {
        return cache.policy().eviction().map(Policy.Eviction::weightedSize).orElseGet(OptionalLong::empty).orElseThrow(() -> new IllegalStateException("Cache \"%s\" does not use a weight based eviction policy".formatted(cache)));
    }

    @Override
    public StorageAbbreviation abbreviate(@NonNull String string) throws StorageException {
        StringWithStorageSystemId stringToIdCacheKey = this.createCacheKey(string);
        StorageAbbreviation id = (StorageAbbreviation)STRING_TO_ID_CACHE.getIfPresent((Object)stringToIdCacheKey);
        if (id != null) {
            return id;
        }
        id = this.abbreviateViaIndex(Collections.singletonList(string)).getFirst();
        ID_TO_STRING_CACHE.put((Object)this.createCacheKey(id), (Object)string);
        STRING_TO_ID_CACHE.put((Object)stringToIdCacheKey, (Object)id);
        return id;
    }

    @Override
    public @NonNull StorageAbbreviationList abbreviateAll(@NonNull Collection<String> strings) throws StorageException {
        ArrayList<StorageAbbreviation> result = new ArrayList<StorageAbbreviation>(strings.size());
        ArrayList<String> missingStrings = new ArrayList<String>();
        ArrayList<Integer> missingStringIndexes = new ArrayList<Integer>();
        int index = 0;
        for (String string : strings) {
            StorageAbbreviation id = (StorageAbbreviation)STRING_TO_ID_CACHE.getIfPresent((Object)this.createCacheKey(string));
            if (id == null) {
                result.add(null);
                missingStrings.add(string);
                missingStringIndexes.add(index);
            } else {
                result.add(id);
            }
            ++index;
        }
        if (!missingStrings.isEmpty()) {
            List<StorageAbbreviation> missingIds = this.abbreviateViaIndex(missingStrings);
            for (int i = 0; i < missingStrings.size(); ++i) {
                StorageAbbreviation resolved = missingIds.get(i);
                result.set((Integer)missingStringIndexes.get(i), resolved);
                STRING_TO_ID_CACHE.put((Object)this.createCacheKey((String)missingStrings.get(i)), (Object)resolved);
                ID_TO_STRING_CACHE.put((Object)this.createCacheKey(resolved), (Object)((String)missingStrings.get(i)));
            }
        }
        return new StorageAbbreviationList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StorageAbbreviation> abbreviateViaIndex(List<String> strings) throws StorageException {
        if (this.store == null) {
            this.store = this.storageSystem.openStore(STRING_ABBREVIATION_INDEX_NAME);
        }
        List keys = CollectionUtils.map(strings, StorageAbbreviator::createStringToIdKey);
        ArrayList<Integer> missingIndexes = new ArrayList<Integer>();
        List<byte[]> stored = this.store.get(keys);
        for (int i = 0; i < stored.size(); ++i) {
            if (stored.get(i) != null) continue;
            missingIndexes.add(i);
        }
        if (!missingIndexes.isEmpty()) {
            Lock lock = this.store.obtainLock("insert");
            lock.lock();
            try {
                this.fillMissingIndexesFromIndexUnderLock(strings, keys, stored, missingIndexes);
            }
            finally {
                lock.unlock();
            }
        }
        return CollectionUtils.map(stored, StorageAbbreviation::of);
    }

    private void fillMissingIndexesFromIndexUnderLock(List<String> strings, List<byte[]> keys, List<byte[]> values, List<Integer> missingIndexes) throws StorageException {
        List missingKeys = CollectionUtils.map(missingIndexes, keys::get);
        List<byte[]> missingValues = this.store.get(missingKeys);
        for (int i = 0; i < missingIndexes.size(); ++i) {
            if (missingValues.get(i) == null) continue;
            values.set((Integer)missingIndexes.get(i), missingValues.get(i));
            missingIndexes.set(i, null);
        }
        if ((missingIndexes = CollectionUtils.filter(missingIndexes, Objects::nonNull)).isEmpty()) {
            return;
        }
        PairList<byte[], byte[]> toInsert = this.createDataForMissingIndexes(strings, keys, values, missingIndexes);
        this.store.put(toInsert);
    }

    private PairList<byte[], byte[]> createDataForMissingIndexes(List<String> strings, List<byte[]> keys, List<byte[]> values, List<Integer> missingIndexes) throws StorageException {
        int currentId = this.getCurrentCounter();
        PairList toInsert = new PairList();
        HashMap<String, StorageAbbreviation> createdIds = new HashMap<String, StorageAbbreviation>();
        for (int missingIndex : missingIndexes) {
            String missingValue = strings.get(missingIndex);
            StorageAbbreviation id = (StorageAbbreviation)createdIds.get(missingValue);
            if (id == null) {
                if (currentId == Integer.MAX_VALUE) {
                    throw new StorageException("Storing too many strings in this project. Running out of ids.");
                }
                id = StorageAbbreviation.of(++currentId);
                createdIds.put(missingValue, id);
            }
            byte[] value = id.toByteArray();
            values.set(missingIndex, value);
            toInsert.add((Object)StorageAbbreviator.createIdToStringKey(id), (Object)StringUtils.stringToBytes((String)missingValue));
            toInsert.add((Object)keys.get(missingIndex), (Object)value);
        }
        toInsert.add((Object)ID_COUNTER_KEY, (Object)ByteArrayUtils.intToByteArray((int)currentId));
        return toInsert;
    }

    private int getCurrentCounter() throws StorageException {
        byte[] value = this.store.get(ID_COUNTER_KEY);
        if (value == null) {
            return 0;
        }
        return ByteArrayUtils.byteArrayToInt((byte[])value);
    }

    @Override
    public @NonNull String unabbreviate(StorageAbbreviation abbreviation) throws StorageException {
        long cacheKey = this.createCacheKey(abbreviation);
        String result = (String)ID_TO_STRING_CACHE.getIfPresent((Object)cacheKey);
        if (result != null) {
            return result;
        }
        result = this.unabbreviateViaIndex(List.of(abbreviation)).getFirst();
        ID_TO_STRING_CACHE.put((Object)cacheKey, (Object)result);
        STRING_TO_ID_CACHE.put((Object)this.createCacheKey(result), (Object)abbreviation);
        return result;
    }

    @Override
    public @NonNull List<String> unabbreviateAll(@NonNull Collection<@NonNull StorageAbbreviation> abbreviations) throws StorageException {
        ArrayList<String> result = new ArrayList<String>(abbreviations.size());
        ArrayList<StorageAbbreviation> missingIds = new ArrayList<StorageAbbreviation>();
        ArrayList<Integer> missingIdIndexes = new ArrayList<Integer>();
        for (StorageAbbreviation abbreviation : abbreviations) {
            String cached = (String)ID_TO_STRING_CACHE.getIfPresent((Object)this.createCacheKey(abbreviation));
            if (cached == null) {
                missingIdIndexes.add(result.size());
                result.add(null);
                missingIds.add(abbreviation);
                continue;
            }
            result.add(cached);
        }
        if (!missingIds.isEmpty()) {
            List<String> missingStrings = this.unabbreviateViaIndex(missingIds);
            for (int i = 0; i < missingIds.size(); ++i) {
                String resolved = missingStrings.get(i);
                result.set((Integer)missingIdIndexes.get(i), resolved);
                ID_TO_STRING_CACHE.put((Object)this.createCacheKey((StorageAbbreviation)missingIds.get(i)), (Object)resolved);
                STRING_TO_ID_CACHE.put((Object)this.createCacheKey(resolved), (Object)((StorageAbbreviation)missingIds.get(i)));
            }
        }
        return result;
    }

    private @NonNull List<String> unabbreviateViaIndex(List<StorageAbbreviation> ids) throws StorageException {
        if (this.store == null) {
            this.store = this.storageSystem.openStore(STRING_ABBREVIATION_INDEX_NAME);
        }
        List<byte[]> values = this.store.get(CollectionUtils.map(ids, StorageAbbreviator::createIdToStringKey));
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) != null) continue;
            throw new StorageException("Did not find string for id %s in abbreviation index. This indicates a corrupt storage system!".formatted(ids.get(i)));
        }
        return CollectionUtils.map(values, StringUtils::bytesToString);
    }

    private long createCacheKey(StorageAbbreviation abbreviation) {
        return (long)this.storageSystem.getStorageSystemId() << 32 | (long)abbreviation.getId();
    }

    private StringWithStorageSystemId createCacheKey(String value) {
        return new StringWithStorageSystemId(value, this.storageSystem.getStorageSystemId());
    }

    private static byte[] createIdToStringKey(StorageAbbreviation id) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{{0}, id.toByteArray()});
    }

    private static byte[] createStringToIdKey(String value) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{{1}, StringUtils.stringToBytes((String)value)});
    }

    @TestOnly
    public static void clearCachesForTesting() {
        ID_TO_STRING_CACHE.invalidateAll();
        STRING_TO_ID_CACHE.invalidateAll();
    }

    static {
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("string_abbreviator_cache_size_bytes")).help("Size metrics for the string abbreviator cache.")).labelNames(new String[]{"type"})).unit(Unit.BYTES)).callback(cb -> {
            cb.call((double)StorageAbbreviator.getEstimatedCacheSizeInBytes(), new String[]{"estimated"});
            cb.call((double)MAXIMUM_CACHE_SIZE_BYTES, new String[]{"max"});
        }).register();
    }

    private record StringWithStorageSystemId(String string, int storageSystemId) {
        private int weight() {
            return this.string.length() + 4;
        }
    }
}

