/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.export;

import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.jsbuild.export.TypescriptType;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.PairList;

public class ExportedTypeScriptClass {
    final Class<?> clazz;
    final PairList<String, TypescriptType> propertiesWithTypes;
    final @Nullable Class<?> superClass;

    ExportedTypeScriptClass(Class<?> clazz, PairList<String, TypescriptType> propertiesWithTypes, Class<?> superClass) {
        this.clazz = clazz;
        this.propertiesWithTypes = propertiesWithTypes;
        this.superClass = superClass;
    }

    public String getSimpleClassName() {
        return this.clazz.getSimpleName();
    }

    Class<?> getParentClass() {
        if (this.superClass == null) {
            return null;
        }
        return this.superClass;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ExportedTypeScriptClass otherExportedClass = (ExportedTypeScriptClass)other;
        return Objects.equals(this.clazz, otherExportedClass.clazz) && Objects.equals(this.propertiesWithTypes, otherExportedClass.propertiesWithTypes) && Objects.equals(this.superClass, otherExportedClass.superClass);
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.propertiesWithTypes, this.superClass);
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

