/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.util.Check;
import java.io.IOException;
import java.io.OutputStream;

public class BinaryWriter {
    private final OutputStream os;
    private final String charsetName;

    public BinaryWriter(OutputStream os, String charsetName) {
        this.os = os;
        this.charsetName = charsetName;
    }

    public void write(boolean value) throws IOException {
        this.write((byte)(value ? 1 : 0));
    }

    public void write(byte value) throws IOException {
        byte[] bytes = new byte[]{value};
        this.os.write(bytes);
    }

    public void write(byte[] value) throws IOException {
        Check.notNull(value, "value");
        this.os.write(value);
    }

    public void write(short value) throws IOException {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >> 8)};
        this.os.write(bytes);
    }

    public void write(int value) throws IOException {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
        this.os.write(bytes);
    }

    public void write(long value) throws IOException {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40), (byte)(value >> 48), (byte)(value >> 56)};
        this.os.write(bytes);
    }

    public void write(String value) throws IOException {
        Check.notNull(value, "value");
        byte[] bytes = value.getBytes(this.charsetName);
        this.writeStringLength(bytes.length);
        this.os.write(bytes);
    }

    public void close() throws IOException {
        this.os.close();
    }

    private void writeStringLength(int value) throws IOException {
        while (value >= 128) {
            this.write((byte)(value | 0x80));
            value >>= 7;
        }
        this.write((byte)value);
    }
}

