/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.LocaleInvariantStringHelpers;
import java.text.MessageFormat;
import java.util.Arrays;
import ms.tfs.versioncontrol.clientservices._03._PropertyValue;

public class PropertyValue
extends WebServiceObjectWrapper {
    private final boolean valueDirty;

    public PropertyValue(String name, Object value) {
        this(new _PropertyValue(name, value, null, null));
    }

    public PropertyValue(_PropertyValue webServiceObject) {
        super(webServiceObject);
        this.valueDirty = true;
    }

    public boolean matchesName(String propertyName) {
        return PropertyValue.comparePropertyNames(this.getPropertyName(), propertyName) == 0;
    }

    public static int comparePropertyNames(String name1, String name2) {
        return String.CASE_INSENSITIVE_ORDER.compare(name1, name2);
    }

    @Override
    public boolean equals(Object o) {
        Object otherValue;
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyValue)) {
            return false;
        }
        PropertyValue other = (PropertyValue)o;
        if (!this.getWebServiceObject().getPname().equalsIgnoreCase(other.getWebServiceObject().getPname())) {
            return false;
        }
        Object thisValue = this.getWebServiceObject().getVal();
        if (thisValue == (otherValue = other.getWebServiceObject().getVal())) {
            return true;
        }
        if (thisValue == null || otherValue == null) {
            return false;
        }
        if (thisValue instanceof byte[] && otherValue instanceof byte[]) {
            return Arrays.equals((byte[])thisValue, (byte[])otherValue);
        }
        return thisValue.equals(otherValue);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.getWebServiceObject().getPname() == null ? 0 : LocaleInvariantStringHelpers.caseInsensitiveHashCode(this.getWebServiceObject().getPname()));
        result = result * 37 + (this.getWebServiceObject().getVal() == null ? 0 : this.getWebServiceObject().getVal().hashCode());
        return result;
    }

    public _PropertyValue getWebServiceObject() {
        return (_PropertyValue)this.webServiceObject;
    }

    public String getPropertyName() {
        return this.getWebServiceObject().getPname();
    }

    public Object getPropertyValue() {
        return this.getWebServiceObject().getVal();
    }

    public Class<?> getPropertyType() {
        Object value = this.getPropertyValue();
        if (value != null) {
            return value.getClass();
        }
        return null;
    }

    public boolean isDirty() {
        return this.valueDirty;
    }

    @Override
    public String toString() {
        return MessageFormat.format("PropertyValue [valueDirty={0}, getPropertyName()={1}, getPropertyValue()={2}, getPropertyType()={3}]", this.valueDirty, this.getPropertyName(), this.getPropertyValue(), this.getPropertyType());
    }
}

