/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DateTime;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.util.Check;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class WorkItemQueryUtils {
    public static Map<String, Object> makeContext(Project project, String teamName) {
        return WorkItemQueryUtils.makeContext(project == null ? null : project.getName(), teamName);
    }

    public static Map<String, Object> makeContext(String projectName, String teamName) {
        HashMap<String, Object> queryContext = new HashMap<String, Object>();
        if (projectName != null) {
            queryContext.put("project", projectName);
        }
        if (teamName != null) {
            queryContext.put("team", teamName);
        }
        return queryContext;
    }

    public static String formatDate(Date date) {
        return DateTime.formatRoundTripUniversal(date);
    }

    public static String escapeValue(String value) {
        Check.notNull(value, "value");
        return value.replaceAll("\\'", "''");
    }

    public static String quoteValue(String value) {
        Check.notNull(value, "value");
        return '\'' + WorkItemQueryUtils.escapeValue(value) + '\'';
    }

    public static String formatValueList(String[] values) {
        Check.notNull(values, "values");
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (int i = 0; i < values.length; ++i) {
            buffer.append(WorkItemQueryUtils.quoteValue(values[i]));
            if (i >= values.length - 1) continue;
            buffer.append(",");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static String bracketFieldName(String fieldName) {
        Check.notNull(fieldName, "fieldName");
        return "[" + fieldName + "]";
    }

    public static String formatFieldList(String[] fieldNames) {
        Check.notNull(fieldNames, "fieldNames");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < fieldNames.length; ++i) {
            buffer.append(WorkItemQueryUtils.bracketFieldName(fieldNames[i]));
            if (i >= fieldNames.length - 1) continue;
            buffer.append(",");
            buffer.append(" ");
        }
        return buffer.toString();
    }
}

