/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.fields;

import com.microsoft.tfs.core.clients.workitem.exceptions.FieldDefinitionNotExistException;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinition;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinitionCollection;
import com.microsoft.tfs.core.clients.workitem.fields.FieldUsages;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.fields.DatastoreItemFieldUsage;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldDefinitionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldReferenceBasedCache;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.FieldDefinitionMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.wittype.WorkItemTypeImpl;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FieldDefinitionCollectionImpl
implements FieldDefinitionCollection {
    private final FieldReferenceBasedCache<FieldDefinition> cache = new FieldReferenceBasedCache();
    private List<FieldDefinition> allFieldDefinitionsSorted;
    private WorkItemType wit = null;

    public FieldDefinitionCollectionImpl(boolean allFieldDefinitionsMode, WITContext context, WorkItemTypeImpl scopeType) {
        if (allFieldDefinitionsMode) {
            this.initializeFromAllFieldDefinitions(context);
        } else {
            this.initializeFromWorkItemPhysicalType(context, scopeType);
        }
    }

    @Override
    public Iterator<FieldDefinition> iterator() {
        return this.allFieldDefinitionsSorted.iterator();
    }

    @Override
    public int size() {
        return this.allFieldDefinitionsSorted.size();
    }

    @Override
    public FieldDefinition[] getFieldDefinitions() {
        return this.allFieldDefinitionsSorted.toArray(new FieldDefinition[this.allFieldDefinitionsSorted.size()]);
    }

    @Override
    public FieldDefinition get(String fieldName) {
        FieldDefinition fieldDefinition = this.cache.get(fieldName);
        if (fieldDefinition == null) {
            throw new FieldDefinitionNotExistException(MessageFormat.format("the field definition with name [{0}] does not exist", fieldName));
        }
        return fieldDefinition;
    }

    @Override
    public boolean contains(String fieldName) {
        return this.cache.get(fieldName) != null;
    }

    public int getSize() {
        return this.cache.size();
    }

    public FieldDefinitionImpl getFieldDefinitionInternal(String fieldName) {
        return (FieldDefinitionImpl)this.get(fieldName);
    }

    public FieldDefinitionImpl getFieldDefinitionInternal(int id) {
        FieldDefinitionImpl fieldDefinition = (FieldDefinitionImpl)this.cache.get(id);
        if (fieldDefinition == null) {
            throw new FieldDefinitionNotExistException(MessageFormat.format("the field definition with id [{0}] does not exist", Integer.toString(id)));
        }
        return fieldDefinition;
    }

    private void initializeFromAllFieldDefinitions(WITContext context) {
        FieldDefinitionMetadata[] allFieldDefinitionsMetadata = context.getMetadata().getFieldsTable().getAllFieldDefinitions();
        ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
        for (int i = 0; i < allFieldDefinitionsMetadata.length; ++i) {
            fieldDefinitions.add(new FieldDefinitionImpl(context, allFieldDefinitionsMetadata[i], this.wit, null));
        }
        this.finishInitialization(fieldDefinitions);
    }

    private void initializeFromWorkItemPhysicalType(WITContext context, WorkItemTypeImpl scopeType) {
        this.wit = scopeType;
        ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
        HashSet<Integer> scopeTypeFieldIds = new HashSet<Integer>();
        if (scopeType != null) {
            int[] workItemFieldIds = context.getMetadata().getWorkItemTypeUsagesTable().getFieldIDsForWorkItemType(scopeType.getID());
            for (int i = 0; i < workItemFieldIds.length; ++i) {
                scopeTypeFieldIds.add(new Integer(workItemFieldIds[i]));
            }
        }
        this.addAllFieldDefinition(context.getWorkItemFieldUsages().getFieldUsages(), scopeType, scopeTypeFieldIds, fieldDefinitions, FieldUsages.WORK_ITEM);
        if (context.isVersion3OrHigher()) {
            this.addAllFieldDefinition(context.getWorkItemLinkFieldUsages().getFieldUsages(), scopeType, scopeTypeFieldIds, fieldDefinitions, FieldUsages.WORK_ITEM_LINK);
        }
        this.finishInitialization(fieldDefinitions);
    }

    private void addAllFieldDefinition(DatastoreItemFieldUsage[] fieldUsages, WorkItemTypeImpl scopeType, Set<Integer> scopeTypeFieldIds, List<FieldDefinition> fieldDefinitions, FieldUsages usage) {
        for (int i = 0; i < fieldUsages.length; ++i) {
            DatastoreItemFieldUsage fieldUsage = fieldUsages[i];
            if (scopeType != null && !fieldUsage.isCore() && !scopeTypeFieldIds.contains(new Integer(fieldUsage.getFieldID()))) continue;
            FieldDefinitionImpl fieldDefinition = fieldUsage.getFieldDefinition();
            fieldDefinition.setUsage(usage);
            if (scopeType != null && this.isInternalFieldDefinition(fieldDefinition)) continue;
            fieldDefinitions.add(fieldDefinition);
        }
    }

    private void finishInitialization(List<FieldDefinition> fieldDefinitions) {
        Collections.sort(fieldDefinitions);
        this.allFieldDefinitionsSorted = fieldDefinitions;
        for (FieldDefinition fieldDefinition : fieldDefinitions) {
            this.cache.put(fieldDefinition, fieldDefinition.getName(), fieldDefinition.getReferenceName(), fieldDefinition.getID());
        }
    }

    private boolean isInternalFieldDefinition(FieldDefinitionImpl field) {
        if (!this.isInternalFieldType(field.getPSType())) {
            return field.isIgnored();
        }
        return true;
    }

    private boolean isInternalFieldType(int psType) {
        switch (psType) {
            case 16: 
            case 24: 
            case 32: 
            case 48: 
            case 64: 
            case 160: 
            case 208: 
            case 224: 
            case 240: 
            case 272: 
            case 288: 
            case 320: 
            case 528: 
            case 576: 
            case 784: {
                return false;
            }
        }
        return true;
    }
}

