/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.IExternal;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Node;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeBoolConst;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeTableName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeVariableList;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Priority;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;

public class NodeAndOperator
extends NodeVariableList {
    public NodeAndOperator() {
        super(NodeType.AND);
    }

    @Override
    public void bind(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        this.bindChildren(e, tableContext, fieldContext);
        for (int childIx = 0; childIx < this.getCount(); ++childIx) {
            Tools.ensureSyntax(this.getItem(childIx).getDataType() == DataType.BOOL, SyntaxError.EXPECTING_BOOLEAN, this.getItem(childIx));
        }
        super.bind(e, tableContext, fieldContext);
    }

    @Override
    public void appendTo(StringBuffer b) {
        super.appendChildren(b, " and ");
    }

    @Override
    public Node optimize(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        this.optimizeChildren(e, tableContext, fieldContext);
        int childIx = 0;
        while (childIx < this.getCount()) {
            if (this.getItem(childIx).getNodeType() == NodeType.BOOL_CONST) {
                if (((NodeBoolConst)this.getItem(childIx)).getValue()) {
                    this.removeAt(childIx);
                    continue;
                }
                return new NodeBoolConst(false);
            }
            ++childIx;
        }
        if (this.getCount() == 0) {
            return new NodeBoolConst(true);
        }
        if (this.getCount() == 1) {
            return this.getItem(0);
        }
        return super.optimize(e, tableContext, fieldContext);
    }

    @Override
    public DataType getDataType() {
        return DataType.BOOL;
    }

    @Override
    public Priority getPriority() {
        return Priority.AND_OPERATOR;
    }
}

