/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;

public class ConnectionInstanceData {
    private final URI serverURI;
    private final GUID sessionId;
    private final AtomicReference<Credentials> credentialsHolder;

    public ConnectionInstanceData(URI serverURI, GUID sessionId) {
        this(serverURI, new AtomicReference<Object>(null), sessionId);
    }

    public ConnectionInstanceData(URI serverURI, AtomicReference<Credentials> credentialsHolder, GUID sessionId) {
        Check.notNull(serverURI, "serverURI");
        Check.notNull(credentialsHolder, "credentialsHolder");
        Check.notNull(sessionId, "sessionId");
        this.serverURI = serverURI;
        this.credentialsHolder = credentialsHolder;
        this.sessionId = sessionId;
    }

    public URI getServerURI() {
        return this.serverURI;
    }

    public AtomicReference<Credentials> getCredentialsHolder() {
        return this.credentialsHolder;
    }

    public void setCredentials(Credentials credentials) {
        this.credentialsHolder.set(credentials);
    }

    public Credentials getCredentials() {
        return this.credentialsHolder.get();
    }

    public GUID getSessionID() {
        return this.sessionId;
    }
}

