/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni;

import com.microsoft.tfs.jni.AuthenticationEngine;
import com.microsoft.tfs.jni.NTLM;
import com.microsoft.tfs.jni.internal.ntlm.JavaNTLM;
import com.microsoft.tfs.jni.internal.ntlm.NTLMException;
import com.microsoft.tfs.jni.internal.ntlm.NativeNTLM;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NTLMEngine
implements AuthenticationEngine {
    private static final Log log = LogFactory.getLog(NTLMEngine.class);
    private static final NTLMEngine instance = new NTLMEngine();
    private final NTLM impl;

    public static NTLMEngine getInstance() {
        return instance;
    }

    private NTLMEngine() {
        NTLM i = null;
        try {
            if (NativeNTLM.isAvailable()) {
                i = new NativeNTLM();
            }
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("{0} reported itself available, but failed to load; falling back to {1}", NativeNTLM.class.getName(), JavaNTLM.class.getName()), (Throwable)e);
        }
        if (i == null) {
            i = new JavaNTLM();
        }
        this.impl = i;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean supportsCredentialsDefault() {
        return this.impl.supportsCredentialsDefault();
    }

    @Override
    public boolean supportsCredentialsSpecified() {
        return this.impl.supportsCredentialsSpecified();
    }

    @Override
    public String getCredentialsDefault() {
        return this.impl.getCredentialsDefault();
    }

    @Override
    public AuthenticationEngine.AuthenticationClient newClient() throws AuthenticationEngine.AuthenticationException {
        return new NTLMClient();
    }

    public class NTLMClient
    implements AuthenticationEngine.AuthenticationClient {
        private final NTLM.NTLMState state;

        private NTLMClient() throws NTLMException {
            this.state = NTLMEngine.this.impl.initialize();
        }

        @Override
        public void setCredentialsDefault() throws AuthenticationEngine.AuthenticationException {
            Check.notNull(this.state, "state");
            NTLMEngine.this.impl.setCredentialsDefault(this.state);
        }

        @Override
        public void setCredentialsSpecified(String username, String domain, String password) throws AuthenticationEngine.AuthenticationException {
            NTLMEngine.this.impl.setCredentialsSpecified(this.state, username, domain, password);
        }

        @Override
        public void setTarget(String target) throws AuthenticationEngine.AuthenticationException {
            NTLMEngine.this.impl.setTarget(this.state, target);
        }

        public void setLocalhost(String localhost) throws AuthenticationEngine.AuthenticationException {
            NTLMEngine.this.impl.setLocalhost(this.state, localhost);
        }

        @Override
        public byte[] getToken(byte[] inputToken) throws AuthenticationEngine.AuthenticationException {
            return NTLMEngine.this.impl.getToken(this.state, inputToken);
        }

        @Override
        public boolean isComplete() throws AuthenticationEngine.AuthenticationException {
            return NTLMEngine.this.impl.isComplete(this.state);
        }

        @Override
        public String getErrorMessage() {
            return NTLMEngine.this.impl.getErrorMessage(this.state);
        }

        @Override
        public void dispose() {
            try {
                NTLMEngine.this.impl.dispose(this.state);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

