/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.authorization;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.impl.authorization.AnnotatedPermissionCheckerBase;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotFoundException;
import java.util.List;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ProjectPermissionChecker
extends AnnotatedPermissionCheckerBase<RequiresProjectPermission> {
    public static final String PROJECT_PATH_PARAMETER = "project";

    ProjectPermissionChecker() {
        super(RequiresProjectPermission.class);
    }

    @Override
    protected void checkPermission(RequiresProjectPermission projectPermission) throws StorageException {
        List<String> projects = this.getPathOrQueryParameters(PROJECT_PATH_PARAMETER, "");
        EProjectPermission[] permissions = projectPermission.value();
        for (IProjectId project2 : CollectionUtils.filterAndMap(projects, project -> !StringUtils.isEmpty((String)project), ProjectIdBase::convert)) {
            for (EProjectPermission permission : permissions) {
                this.checkPermissionForProject(project2, permission);
            }
        }
    }

    private void checkPermissionForProject(IProjectId project, EProjectPermission permission) throws StorageException {
        try {
            this.serviceInfo.getPermissions().checkProjectPermission(project, permission);
        }
        catch (ForbiddenException e) {
            if (((ProjectIndex)this.serviceInfo.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class)).tryResolveProject(project).isEmpty()) {
                throw new NotFoundException("Project " + String.valueOf(project) + " doesn't exist or you don\u2019t have the necessary permissions!", (Throwable)e);
            }
            throw e;
        }
    }
}

