/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.handler;

import com.teamscale.core.ai.IAiEngineProvider;
import com.teamscale.core.authenticate.AuthenticationRequestHandler;
import com.teamscale.core.config.ServerConfiguration;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.user.User;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import java.net.URI;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.cache.StorageCacheConfiguration;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

class TeamscaleServiceInfo
implements ITeamscaleServiceInfo {
    private final PublicProjectId publicId;
    private final StorageCacheConfiguration storageCacheConfiguration;
    private final ServicePermissions permissions;
    private final GlobalStorageSystem globalStorageSystem;
    private final InternalProjectId internalId;
    private final User user;
    private final CommitResolvingStorageSystem projectStorageSystem;
    private final IndexLayer indexLayer;
    private final ServerConfiguration serverConfiguration;
    private final IMessageBroker messageBroker;
    private final ILockProvider lockProvider;
    private final boolean serviceLogIncludeUsers;
    private final AuthenticationRequestHandler authenticationRequestHandler;
    private final URI baseUri;
    private final IAiEngineProvider aiEngineProvider;

    public TeamscaleServiceInfo(ServicePermissions permissions, IndexLayer indexLayer, InternalProjectId internalId, PublicProjectId publicId, User user, ServerConfiguration serverConfiguration, ILockProvider lockProvider, StorageCacheConfiguration storageCacheConfiguration, boolean noProjectStorageSystem, boolean serviceLogIncludeUsers, AuthenticationRequestHandler authenticationRequestHandler, URI baseUri, IAiEngineProvider aiEngineProvider) throws StorageException {
        this.permissions = permissions;
        this.storageCacheConfiguration = storageCacheConfiguration;
        this.indexLayer = indexLayer;
        this.globalStorageSystem = indexLayer.openGlobalStorageSystem();
        this.internalId = internalId;
        this.publicId = publicId;
        this.user = user;
        this.authenticationRequestHandler = authenticationRequestHandler;
        this.baseUri = baseUri;
        this.projectStorageSystem = internalId == null || SchedulingConstants.isMaintenance((IProjectId)internalId) || noProjectStorageSystem ? null : indexLayer.openProjectStorageSystem((IProjectId)internalId, storageCacheConfiguration);
        this.serverConfiguration = serverConfiguration;
        this.lockProvider = lockProvider;
        this.messageBroker = indexLayer.getMessageBroker();
        this.serviceLogIncludeUsers = serviceLogIncludeUsers;
        this.aiEngineProvider = aiEngineProvider;
    }

    public GlobalStorageSystem getGlobalStorageSystem() {
        return this.globalStorageSystem;
    }

    public ServicePermissions getPermissions() {
        return this.permissions;
    }

    public InternalProjectId getInternalId() {
        return this.internalId;
    }

    public PublicProjectId getPrimaryPublicId() {
        return this.publicId;
    }

    public User getUser() {
        return this.user;
    }

    public CommitResolvingStorageSystem getProjectStorageSystem() {
        return this.projectStorageSystem;
    }

    public CommitResolvingStorageSystem getProjectStorageSystem(IProjectId projectId) throws StorageException {
        return this.indexLayer.openProjectStorageSystem(projectId, this.storageCacheConfiguration);
    }

    public CommitResolvingStorageSystem getProjectStorageSystem(ProjectInfo project) throws StorageException {
        return this.indexLayer.openProjectStorageSystem((IProjectId)project.getInternalId(), this.storageCacheConfiguration);
    }

    public StorageCacheConfiguration getStorageCacheConfiguration() {
        return this.storageCacheConfiguration;
    }

    public IndexLayer getIndexLayer() {
        return this.indexLayer;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public ILockProvider getLockProvider() {
        return this.lockProvider;
    }

    public URI getRequestBaseUri() {
        return this.baseUri;
    }

    public IMessageBroker getMessageBroker() {
        return this.messageBroker;
    }

    public boolean isServiceLogIncludeUsers() {
        return this.serviceLogIncludeUsers;
    }

    public AuthenticationRequestHandler getAuthenticationRequestHandler() {
        return this.authenticationRequestHandler;
    }

    public IAiEngineProvider getAiEngineProvider() {
        return this.aiEngineProvider;
    }
}

