/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis;

import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.IndexDelta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public final class KeyDelta
extends IndexDelta<StorageKey> {
    private static final long serialVersionUID = 1L;
    private static final KeyDelta EMPTY = new KeyDelta((Collection<StorageKey>)Collections.emptyList(), (Collection<StorageKey>)Collections.emptyList());

    public KeyDelta(Collection<StorageKey> addedOrChanged, Collection<StorageKey> deleted) {
        super(addedOrChanged, deleted, Comparator.naturalOrder());
    }

    public static KeyDelta empty() {
        return EMPTY;
    }

    public static KeyDelta combineDeltas(Collection<KeyDelta> deltas) {
        return EMPTY.combine(deltas);
    }

    public static KeyDelta aggregateDeltas(Collection<KeyDelta> deltas) {
        HashSet<StorageKey> aggregatedAddedOrChanged = new HashSet<StorageKey>();
        HashSet<StorageKey> aggregatedDeleted = new HashSet<StorageKey>();
        for (KeyDelta keyDelta : deltas) {
            CollectionUtils.removeAll(aggregatedAddedOrChanged, keyDelta.getDeletedKeys());
            CollectionUtils.removeAll(aggregatedDeleted, keyDelta.getAddedOrChangedKeys());
            aggregatedAddedOrChanged.addAll((Collection<StorageKey>)keyDelta.getAddedOrChangedKeys());
            aggregatedDeleted.addAll((Collection<StorageKey>)keyDelta.getDeletedKeys());
        }
        return new KeyDelta((Collection<StorageKey>)aggregatedAddedOrChanged, (Collection<StorageKey>)aggregatedDeleted);
    }

    public List<byte[]> getAddedOrChangedKeysAsBytes() {
        return CollectionUtils.map(this.getAddedOrChangedKeys(), StorageKey::getKey);
    }

    public List<String> getAddedOrChangedKeysAsStrings() {
        return KeyDelta.asStrings(this.getAddedOrChangedKeys());
    }

    public List<byte[]> getDeletedKeysAsBytes() {
        return CollectionUtils.map(this.getDeletedKeys(), StorageKey::getKey);
    }

    public List<String> getDeletedKeysAsStrings() {
        return KeyDelta.asStrings(this.getDeletedKeys());
    }

    public List<String> getAllKeysAsStrings() {
        return new ArrayList<String>(CollectionUtils.unionSet(this.getAddedOrChangedKeysAsStrings(), (Collection[])new Collection[]{this.getDeletedKeysAsStrings()}));
    }

    private static List<String> asStrings(List<StorageKey> storageKeys) {
        return CollectionUtils.map(storageKeys, StorageKey::getAsString);
    }

    public static KeyDelta fromStrings(Collection<String> addedOrChanged, Collection<String> deleted) {
        return new KeyDelta(KeyDelta.convertToStorageKeys(addedOrChanged), KeyDelta.convertToStorageKeys(deleted));
    }

    private static Collection<StorageKey> convertToStorageKeys(Collection<String> paths) {
        ArrayList<StorageKey> storageKeys = new ArrayList<StorageKey>();
        for (String path : paths) {
            storageKeys.add(new StorageKey(path));
        }
        return storageKeys;
    }

    @Override
    public List<KeyDelta> split(int maxDeltaSize) {
        return super.split(maxDeltaSize);
    }

    @Override
    public KeyDelta combine(Collection<? extends IIndexDelta> deltas) {
        return (KeyDelta)super.combine((Collection)deltas);
    }

    @Override
    protected IndexDelta<StorageKey> create(Collection<StorageKey> addedOrChanged, Collection<StorageKey> deleted, @Nullable Comparator<StorageKey> comparator) {
        return new KeyDelta(addedOrChanged, deleted);
    }
}

