/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.core.findings.FindingsSchema;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompiler;
import com.teamscale.core.runtime.impl.rollback.PostRevisionAnalysisTriggerBase;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.ExternalStorageProjectMappingId;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.IMountableStorageIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IProjectIndexBase;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexValidationUtils;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.IndexSchemaCache;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.rollback.StoreRollbackUtils;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class ProjectCreationProxy {
    private final InternalProjectId internalId;
    private final ExternalStorageProjectMappingId externalId;
    private final @Nullable InternalProjectId parentProjectId;
    private List<PublicProjectId> publicIds;
    private final String fullName;
    private final ProjectConfiguration newProjectConfiguration;
    private final @Nullable ProjectConfiguration previousProjectConfiguration;
    private final String description;
    private final IndexSchema.Builder schemaBuilder = IndexSchema.builder();
    private final Set<String> triggerNames = new HashSet<String>();
    protected final PairList<String, TriggerDescription> triggerDescriptions = new PairList();
    private final @Nullable List<AnalysisTrigger> previousTriggers;
    protected final CodeScopeAware<FindingsSchema> findingsSchemas = CodeScopeAware.empty();
    private final CodeScopeAware<PairList<String, FindingTypeDescription>> findingTypeDescriptions = CodeScopeAware.empty();
    private final Map<MetricSchemaIndex.EMetricSchemaType, MetricSchemaProxy> schemaProxies = new EnumMap<MetricSchemaIndex.EMetricSchemaType, MetricSchemaProxy>(MetricSchemaIndex.EMetricSchemaType.class);
    private final List<Serializable> metaIndexEntries = new ArrayList<Serializable>();
    private final Map<String, String> metaIndexStringValues = new HashMap<String, String>();
    private final CodeScopeAware<Set<ELanguage>> languages = CodeScopeAware.emptyWithDefault(new HashSet());
    private final List<CodeScope> codeScopes = new ArrayList<CodeScope>();
    private final PairList<EAnalysisState, Class<? extends PostRevisionAnalysisTriggerBase>> postRevisionAnalysisTriggersByAnalysisState = new PairList();
    private final Set<String> postBuildCompletenessTriggerNames = new HashSet<String>();

    public ProjectCreationProxy(InternalProjectId internalId, ExternalStorageProjectMappingId externalId, @Nullable InternalProjectId parentProjectId, CodeScopeAware<Set<ELanguage>> configuredLanguages, ProjectConfiguration newProjectConfiguration, @Nullable ProjectConfiguration previousProjectConfiguration, @Nullable List<AnalysisTrigger> previousTriggers, List<CodeScope> codeScopes) {
        this.internalId = internalId;
        this.externalId = externalId;
        this.parentProjectId = parentProjectId;
        this.fullName = newProjectConfiguration.getName();
        this.newProjectConfiguration = newProjectConfiguration;
        this.previousProjectConfiguration = previousProjectConfiguration;
        this.publicIds = newProjectConfiguration.getPublicIds();
        this.description = newProjectConfiguration.getDescription();
        this.previousTriggers = previousTriggers;
        this.schemaBuilder.setParentProjectId(parentProjectId);
        for (CodeScopeName codeScopeName : configuredLanguages.getCodeScopeNames()) {
            this.languages.setValue(codeScopeName, configuredLanguages.getValue(codeScopeName));
        }
        this.codeScopes.addAll(codeScopes);
        codeScopes.forEach(codeScope -> {
            this.findingsSchemas.setValue(codeScope.getName(), new FindingsSchema());
            this.findingTypeDescriptions.setValue(codeScope.getName(), (PairList<String, FindingTypeDescription>)new PairList());
        });
    }

    public InternalProjectId getInternalId() {
        return this.internalId;
    }

    public ExternalStorageProjectMappingId getExternalId() {
        return this.externalId;
    }

    public CodeScopeAware<Set<ELanguage>> getConfiguredLanguages() {
        return this.languages;
    }

    @VisibleForTesting
    IndexSchema.Builder getSchemaBuilder() {
        return this.schemaBuilder;
    }

    public void setPublicIds(List<PublicProjectId> publicIds) {
        this.publicIds = publicIds;
    }

    public synchronized void createProjectIndex(Class<? extends IProjectIndexBase> indexClass) {
        this.createProjectIndexInternal(indexClass, null);
    }

    public synchronized void createProjectIndex(Class<? extends IProjectIndexWithDynamicName> indexClass, String indexName) {
        this.createProjectIndexInternal(indexClass, Objects.requireNonNull(indexName, "indexName"));
    }

    private synchronized void createProjectIndexInternal(Class<? extends IStorageIndex> indexClass, @Nullable String indexNameHint) {
        Index indexAnnotation = IStorageIndex.getIndexAnnotation(indexClass);
        String indexName = Objects.requireNonNullElse(indexNameHint, indexAnnotation.name());
        IndexValidationUtils.validateIndexClass(indexClass);
        SchemaEntry schemaEntry = new SchemaEntry(indexClass, indexAnnotation);
        SchemaEntry existingEntry = this.schemaBuilder.getEntry(indexName);
        ProjectCreationProxy.validateSchemaEntry(indexClass, indexName, schemaEntry, existingEntry);
        this.schemaBuilder.updateWithSchemaEntry(indexName, schemaEntry);
    }

    private static void validateSchemaEntry(Class<? extends IStorageIndex> indexClass, String indexName, SchemaEntry schemaEntry, SchemaEntry existingEntry) {
        if (existingEntry != null && !existingEntry.equals((Object)schemaEntry)) {
            throw new IllegalStateException("Incompatible definitions for index " + indexName);
        }
        boolean isMountableStore = schemaEntry.getStorageOptions().contains((Object)EStorageOption.CROSS_PROJECT_MOUNTABLE);
        boolean implementsMountableInterface = IMountableStorageIndex.class.isAssignableFrom(indexClass);
        if (isMountableStore && !implementsMountableInterface) {
            throw new IllegalArgumentException("Index " + indexName + " uses storage option " + String.valueOf(EStorageOption.CROSS_PROJECT_MOUNTABLE) + " but doesn't implement the " + IMountableStorageIndex.class.getSimpleName() + " interface.");
        }
        if (implementsMountableInterface && !isMountableStore) {
            throw new IllegalArgumentException("Index " + indexName + " implements the " + IMountableStorageIndex.class.getSimpleName() + " interface but doesn't use the storage option " + String.valueOf(EStorageOption.CROSS_PROJECT_MOUNTABLE));
        }
    }

    public String createTrigger(TriggerBuilder triggerBuilder) throws ProjectConfigurationException {
        return this.createTrigger(triggerBuilder, null);
    }

    public boolean isTriggerAlreadyCreated(String triggerName) {
        return this.triggerNames.contains(triggerName);
    }

    public boolean isMetaIndexEntryAlreadyAdded(Serializable metaIndexEntry) {
        return new HashSet<Serializable>(this.metaIndexEntries).contains(metaIndexEntry);
    }

    public boolean isProjectIndexAlreadyCreated(Class<? extends IProjectIndex> indexClass) {
        String indexName = IStorageIndex.getIndexAnnotation(indexClass).name();
        return this.schemaBuilder.getEntry(indexName) != null;
    }

    public String createTrigger(TriggerBuilder triggerBuilder, String namePrefix) throws ProjectConfigurationException {
        String triggerName = this.createTriggerName(triggerBuilder, namePrefix);
        if (!this.triggerNames.add(triggerName)) {
            throw new ProjectConfigurationException("Trigger name " + triggerName + " already used in project " + String.valueOf(this.internalId));
        }
        this.triggerDescriptions.add((Object)triggerName, (Object)triggerBuilder.toTriggerDescription());
        return triggerName;
    }

    private String createTriggerName(TriggerBuilder triggerBuilder) {
        return this.createTriggerName(triggerBuilder, null);
    }

    private String createTriggerName(TriggerBuilder triggerBuilder, String namePrefix) {
        String triggerName = triggerBuilder.getSimpleTriggerName();
        if (!StringUtils.isEmpty((String)namePrefix)) {
            triggerName = TriggerBuilder.buildTriggerName(namePrefix, triggerName);
        }
        return triggerName;
    }

    public void addMetaIndexEntry(Serializable entry) throws ProjectConfigurationException {
        for (Serializable existingEntry : this.metaIndexEntries) {
            if (!existingEntry.getClass().equals(entry.getClass())) continue;
            throw new ProjectConfigurationException("Attempting to store two meta index entries for class " + String.valueOf(entry.getClass()));
        }
        this.metaIndexEntries.add(entry);
    }

    public void addMetaIndexStringValue(String key, String value) throws ProjectConfigurationException {
        if (this.metaIndexStringValues.containsKey(key)) {
            throw new ProjectConfigurationException("Attempting to store two string values to same key '" + key + "' in meta index!");
        }
        this.metaIndexStringValues.put(key, value);
    }

    public void checkConsistency(SchemaAwareStorageSystem globalStorageSystem) throws TriggerCompilationException, ProjectConfigurationException {
        IndexSchema schema = this.schemaBuilder.build();
        ProjectCreationProxy.checkRollbackSupport(schema);
        for (String entryName : schema.getEntryNames()) {
            SchemaEntry schemaEntry = schema.getEntry(entryName);
            UnmodifiableSet storageOptions = schemaEntry.getStorageOptions();
            if (!storageOptions.contains((Object)EStorageOption.CROSS_PROJECT_MOUNTABLE) || storageOptions.contains((Object)EStorageOption.BACKUP)) continue;
            throw new ProjectConfigurationException("Invalid schema entry " + entryName + " for index class " + schemaEntry.getIndexClass() + ". Index uses the " + EStorageOption.CROSS_PROJECT_MOUNTABLE.name() + " storage option but doesn't use the required storage option " + EStorageOption.BACKUP.name() + ".");
        }
        new TriggerCompiler(schema, globalStorageSystem.getSchema()).compile(this.triggerDescriptions);
    }

    private static void checkRollbackSupport(IndexSchema schema) throws ProjectConfigurationException {
        for (String name : schema.getEntryNames()) {
            try {
                if (StoreRollbackUtils.supportsRollback((SchemaEntry)schema.getEntry(name))) continue;
                throw new ProjectConfigurationException("No rollback support found for store " + name);
            }
            catch (StorageException e) {
                throw new ProjectConfigurationException("Could not determine rollback support for store " + name, e);
            }
        }
    }

    public void createProject(IndexLayer indexLayer, boolean assumeExisting, boolean createTriggers) throws StorageException {
        IndexSchema indexSchema = this.schemaBuilder.build();
        this.discardUnusedOldStores(assumeExisting, indexLayer, indexSchema);
        indexLayer.saveProjectIndexSchema((IProjectId)this.internalId, indexSchema);
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)this.internalId);
        this.storeProjectInfo(indexLayer, assumeExisting, createTriggers);
        TriggerIndex triggerIndex = (TriggerIndex)projectStorageSystem.openProjectIndex(TriggerIndex.class, null);
        if (assumeExisting) {
            triggerIndex.removeAllTriggers();
        }
        if (createTriggers) {
            triggerIndex.setTriggers(this.triggerDescriptions);
            for (Pair pair : this.postRevisionAnalysisTriggersByAnalysisState) {
                triggerIndex.addPostRevisionAnalysisTrigger((EAnalysisState)((Object)pair.getFirst()), (Class)pair.getSecond());
            }
            for (String triggerName : this.postBuildCompletenessTriggerNames) {
                triggerIndex.addPostBuildCompletenessAnalysisTrigger(triggerName);
            }
        }
        if (!assumeExisting) {
            this.writeSchemas(projectStorageSystem);
        }
        this.resetMetaIndexEntries(projectStorageSystem);
    }

    private void storeProjectInfo(IndexLayer indexLayer, boolean assumeExisting, boolean createTriggers) throws StorageException {
        ProjectIndex projectIndex = indexLayer.openGlobalIndex(ProjectIndex.class);
        ProjectInfo projectInfo = assumeExisting ? projectIndex.resolveProject((IProjectId)this.internalId) : new ProjectInfo(this.internalId, this.externalId, this.fullName, this.publicIds, this.parentProjectId, this.description, DateTimeUtils.millisNow(), this.newProjectConfiguration.getPreselectedUIBranch());
        projectInfo.setConfigurationCompleted(createTriggers);
        projectIndex.setProject(projectInfo);
    }

    private void writeSchemas(ProjectStorageSystem projectStorageSystem) throws StorageException {
        for (Map.Entry<MetricSchemaIndex.EMetricSchemaType, MetricSchemaProxy> entry : this.schemaProxies.entrySet()) {
            String indexName = entry.getKey().getIndexName();
            MetricSchemaProxy schemaProxy = entry.getValue();
            if (!projectStorageSystem.hasIndex(indexName)) continue;
            schemaProxy.persistTo((MetricSchemaIndex)projectStorageSystem.openProjectIndex(MetricSchemaIndex.class, indexName, HistoryAccessOption.readHeadWriteTimestampUnbranched((long)1L)));
        }
        FindingsSchemaIndex findingsSchemaIndex = (FindingsSchemaIndex)projectStorageSystem.openProjectIndex(FindingsSchemaIndex.class, null);
        for (CodeScope codeScope : this.codeScopes) {
            CodeScopeName codeScopeName = codeScope.getName();
            findingsSchemaIndex.setFindingsSchema(this.findingsSchemas.getValue(codeScopeName), codeScopeName);
            findingsSchemaIndex.setFindingTypeDescriptions(codeScopeName, this.findingTypeDescriptions.getValue(codeScopeName));
        }
    }

    private void discardUnusedOldStores(boolean assumeExisting, IndexLayer indexLayer, IndexSchema newSchema) throws StorageException {
        if (!assumeExisting) {
            return;
        }
        IStorageSystem projectStorageSystem = indexLayer.getRawStorageSystemProvider().openStorageSystem(this.internalId);
        IndexSchema indexSchema = IndexSchema.load((IStorageSystem)projectStorageSystem, (SynchronizedCacheAccess)IndexSchemaCache.UNCACHED_ACCESS);
        UnmodifiableSet oldStoreNames = indexSchema.getEntryNames();
        UnmodifiableSet newStoreNames = newSchema.getEntryNames();
        for (String storeToBeDeleted : CollectionUtils.differenceSet((Collection)oldStoreNames, (Collection[])new Collection[]{newStoreNames})) {
            projectStorageSystem.removeStore(storeToBeDeleted);
        }
    }

    private void resetMetaIndexEntries(ProjectStorageSystem projectStorageSystem) throws StorageException {
        MetaIndex metaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        metaIndex.clear();
        for (Serializable serializable : this.metaIndexEntries) {
            metaIndex.setValue(serializable, serializable.getClass());
        }
        for (Map.Entry entry : this.metaIndexStringValues.entrySet()) {
            metaIndex.setStringValue((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Deprecated
    public void addFindingsSchemaEntry(String analysisCategory, String analysisGroup, FindingDescriptor findingDescriptor) {
        this.addFindingsSchemaEntry(analysisCategory, analysisGroup, findingDescriptor, CodeScopeAware.DEFAULT_CODE_SCOPE);
    }

    public void addFindingsSchemaEntry(String analysisCategory, String analysisGroup, FindingDescriptor findingDescriptor, CodeScopeName codeScopeName) {
        if (findingDescriptor.getEnablement().isEnabled()) {
            String findingTypeId = IndexFinding.makeFindingTypeId((String)analysisCategory, (String)analysisGroup);
            this.findingsSchemas.getValue(codeScopeName).addMapping(findingTypeId, findingDescriptor);
            this.findingTypeDescriptions.getValue(codeScopeName).add((Object)findingTypeId, (Object)new FindingTypeDescription(findingDescriptor));
        }
    }

    public void addFindingsSchemaEntry(String findingTypeId, FindingDescriptor findingDescriptor, CodeScopeName codeScopeName) {
        if (findingDescriptor.getEnablement().isEnabled()) {
            this.findingsSchemas.getValue(codeScopeName).addMapping(findingTypeId, findingDescriptor);
            this.findingTypeDescriptions.getValue(codeScopeName).add((Object)findingTypeId, (Object)new FindingTypeDescription(findingDescriptor));
        }
    }

    public MetricSchemaProxy getCodeMetricSchema() {
        return this.getMetricSchema(MetricSchemaIndex.EMetricSchemaType.CODE);
    }

    public MetricSchemaProxy getProcessMetricSchema() {
        return this.getMetricSchema(MetricSchemaIndex.EMetricSchemaType.PROCESS);
    }

    public MetricSchemaProxy getTestExecutionMetricsSchema() {
        return this.getMetricSchema(MetricSchemaIndex.EMetricSchemaType.TEST_EXECUTION);
    }

    public MetricSchemaProxy getWorkItemMetricSchema() {
        return this.getMetricSchema(MetricSchemaIndex.EMetricSchemaType.WORK_ITEM);
    }

    private MetricSchemaProxy getMetricSchema(MetricSchemaIndex.EMetricSchemaType schemaType) {
        CCSMAssert.isNotNull((Object)((Object)schemaType), () -> String.format("Expected \"%s\" to be not null", "schemaType"));
        return this.schemaProxies.computeIfAbsent(schemaType, ignored -> new MetricSchemaProxy(this.internalId));
    }

    public List<PublicProjectId> getPublicIds() {
        return this.publicIds;
    }

    public List<CodeScope> getCodeScopes() {
        return this.codeScopes;
    }

    public void addPostRevisionAnalysisTrigger(EAnalysisState analysisState, Class<? extends PostRevisionAnalysisTriggerBase> trigger) {
        for (int i = 0; i < this.postRevisionAnalysisTriggersByAnalysisState.size(); ++i) {
            if (this.postRevisionAnalysisTriggersByAnalysisState.getFirst(i) != analysisState || this.postRevisionAnalysisTriggersByAnalysisState.getSecond(i) != trigger) continue;
            return;
        }
        this.postRevisionAnalysisTriggersByAnalysisState.add((Object)analysisState, trigger);
    }

    public void addPostBuildCompletenessAnalysisTrigger(TriggerBuilder triggerBuilder) {
        this.postBuildCompletenessTriggerNames.add(this.createTriggerName(triggerBuilder));
    }

    public void addPostBuildCompletenessAnalysisTrigger(String triggerName) {
        this.postBuildCompletenessTriggerNames.add(triggerName);
    }

    private @Nullable ProjectConfiguration getPreviousProjectConfiguration() {
        return this.previousProjectConfiguration;
    }

    public ProjectConfiguration getNewProjectConfiguration() {
        return this.newProjectConfiguration;
    }

    public @Nullable List<AnalysisTrigger> getPreviousTriggers() {
        return this.previousTriggers;
    }

    public Optional<ConnectorConfiguration> getConnectorFromPreviousConfiguration(String connectorIdentifier) {
        ProjectConfiguration previousProjectConfiguration = this.getPreviousProjectConfiguration();
        if (previousProjectConfiguration == null) {
            return Optional.empty();
        }
        return previousProjectConfiguration.getConnectors().stream().filter(connectorConfiguration -> connectorConfiguration.getIdentifier().equals(connectorIdentifier)).findFirst();
    }

    public void addMetaIndexExternalLinkTemplates(String connectorIdentifier, String commitLinkTemplate, String commitInMergeRequestLinkTemplate) throws ProjectConfigurationException {
        this.addMetaIndexStringValue(MetaIndex.makeExternalLinkTemplateForCommitKey((String)connectorIdentifier), commitLinkTemplate);
        this.addMetaIndexStringValue(MetaIndex.makeExternalLinkTemplateForCommitInMergeRequestKey((String)connectorIdentifier), commitInMergeRequestLinkTemplate);
    }

    public EnumSet<ELanguage> getAllConfiguredLanguages() {
        EnumSet<ELanguage> unionOverCodeScopes = EnumSet.noneOf(ELanguage.class);
        for (CodeScope codeScope : this.getCodeScopes()) {
            unionOverCodeScopes.addAll((Collection<ELanguage>)this.languages.getValue(codeScope.getName()));
        }
        return unionOverCodeScopes;
    }

    public List<CodeScopeName> getCodeScopeNames() {
        return this.codeScopes.stream().map(CodeScope::getName).toList();
    }
}

