/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.crowd;

import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.ImportUsersStrategyBase;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.crowd.CrowdServerDescription;
import com.teamscale.core.authenticate.crowd.CrowdUtils;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

class CrowdImportUsersStrategy
extends ImportUsersStrategyBase<CrowdServerDescription> {
    private final UserIndex userIndex;
    private final IMessageBroker messageBroker;

    public CrowdImportUsersStrategy(NamedServer<CrowdServerDescription> server, UserIndex userIndex, IMessageBroker messageBroker) {
        super(server);
        this.userIndex = userIndex;
        this.messageBroker = messageBroker;
    }

    @Override
    public List<User> importUser(String userName) throws StorageException, AuthenticationToolException {
        Optional<User> user = CrowdUtils.updateOrImportUser(userName, this.getServer(), this.userIndex, this.messageBroker);
        return CollectionUtils.emptyListIfEmpty(user);
    }
}

