/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.ESsoAuthenticatorType;
import com.teamscale.core.authenticate.ISsoAuthenticatorOption;
import com.teamscale.core.authenticate.github.GitHubUtils;
import com.teamscale.core.authenticate.github.client.GitHubAppClient;
import com.teamscale.core.authenticate.github.dto.App;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndexSynchronizer;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.MultilineOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@ExportToTypeScript
@Option(id="auth.github.application", name="GitHub Application", type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.GITHUB, orderingHint=500)
@IndexValueClass(containedInBackup=true)
public class GitHubApplicationDescription
implements ISsoAuthenticatorOption {
    private static final Logger LOGGER = LogManager.getLogger(GitHubApplicationDescription.class);
    private static final Map<String, Integer> PROTOCOL_TO_PORT = CollectionUtils.asMap((Pair[])new Pair[]{Pair.createPair((Object)"http", (Object)80), Pair.createPair((Object)"https", (Object)443)});
    private static final long serialVersionUID = 1L;
    public static final String ALLOWED_ORGANIZATIONS_FOR_SSO_OPTION_NAME = "Allowed Organizations for SSO";
    public static final String DEFAULT_GROUPS_FOR_IMPORTED_USERS_OPTION_NAME = "Default groups for imported users";
    private static final String INSECURE_CONFIGURATION_MESSAGE = "\nSetting a 'Default groups for imported users' without specifying any 'Allowed Organizations for SSO' can create a security vulnerability. If your GitHub app is available to other organizations, a user from an unauthorized organization could install the app on their organization and gain access to your Teamscale instance via SSO. They would be assigned to the default group, potentially giving them access to projects on Teamscale which they would usually not have access to on GitHub. To mitigate this risk, it is recommended to simply enter allowed organization names (as in the URL) in the 'Allowed Organizations for SSO' field.";
    @JsonIgnore
    private boolean shouldSynchronizeInstallationIndex = false;
    @JsonIgnore
    private @Nullable String previousAppId = null;
    @JsonProperty(value="serverUrl")
    @OptionFieldDescription(name="GitHub URL")
    public String serverUrl = "https://github.com/";
    @JsonProperty(value="appId")
    @OptionFieldDescription(name="ID of the GitHub App")
    public String appId;
    @JsonProperty(value="urlName")
    @OptionFieldDescription(name="App Name (as used in the URL)")
    public String urlName;
    @JsonProperty(value="privateKey")
    @MultilineOption
    @OptionFieldDescription(name="Application private key (PEM)")
    public String privateKey;
    @JsonProperty(value="webhookSecret")
    @OptionFieldDescription(name="Secret used for securing webhook calls (optional)")
    @PasswordOption
    public String webhookSecret;
    @JsonProperty(value="clientId")
    @OptionFieldDescription(name="OAuth client id")
    public String clientId;
    @JsonProperty(value="clientSecret")
    @OptionFieldDescription(name="OAuth client secret")
    @PasswordOption
    public String clientSecret;
    @JsonProperty(value="skipCollaboratorCheck")
    @OptionFieldDescription(name="Skip check if the current user is a collaborator during project creation")
    public boolean skipCollaboratorCheck = EFeatureToggle.ENABLE_DEV_MODE.isEnabled();
    @JsonProperty(value="useForSso")
    @OptionFieldDescription(name="Use GitHub for Single sign-on (SSO)")
    public boolean useForSso = true;
    @JsonProperty(value="loginButtonDisplayName")
    @OptionFieldDescription(name="Display name for the login button")
    public String loginButtonDisplayName;
    @JsonProperty(value="createUserOnFirstLogin")
    @OptionFieldDescription(name="Create a new user on first login")
    public boolean createUserOnFirstLogin = true;
    @JsonProperty(value="allowedOrganizations")
    @OptionFieldDescription(name="Allowed Organizations for SSO", description="Comma-separated list of organizations whose members are allowed to login with SSO. If this option is not set, all organizations the app is installed on are allowed.")
    public String allowedOrganizations;
    @JsonProperty(value="groups")
    @OptionFieldDescription(name="Default groups for imported users")
    public String groups;

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        String urlIssues;
        Optional<String> applicationValidation = this.validateApplication();
        if (applicationValidation.isPresent()) {
            return applicationValidation.get();
        }
        if (this.isConfiguredInsecurely()) {
            return INSECURE_CONFIGURATION_MESSAGE;
        }
        if (!StringUtils.isEmpty((String)this.serverUrl)) {
            this.serverUrl = StringUtils.ensureEndsWith((String)this.serverUrl, (String)"/");
        }
        if ((urlIssues = this.validateUrl()) != null) {
            return urlIssues;
        }
        String connectivityIssues = this.validateConnectivity();
        if (connectivityIssues != null) {
            return connectivityIssues;
        }
        UserGroupIndex groupIndex = (UserGroupIndex)storageInfo.getGlobalStorageSystem().openGlobalIndex(UserGroupIndex.class);
        for (String groupName : this.getGroups()) {
            UserGroup group = groupIndex.getUserGroup(groupName);
            if (group != null) continue;
            return "Group " + groupName + " does not exist!";
        }
        return null;
    }

    private String validateConnectivity() {
        try {
            App app = this.fetchGitHubApp();
            if (this.getAppId() != app.getId()) {
                return "App ID returned (" + app.getId() + ") differs from configured App ID!";
            }
        }
        catch (ServiceCallException e) {
            return "Failed to contact GitHub API: " + e.getMessage();
        }
        return null;
    }

    @VisibleForTesting
    String validateUrl() {
        if (StringUtils.isEmpty((String)this.serverUrl)) {
            return "Server URL not provided!";
        }
        try {
            URI uri = new URI(this.serverUrl);
            if (!PROTOCOL_TO_PORT.containsKey(uri.getScheme())) {
                return "Unsupported or missing protocol: " + uri.getScheme();
            }
            if (!StringUtils.stripSuffix((String)uri.getPath(), (String)"/").isEmpty()) {
                return "Path of server URL must be empty!";
            }
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return "Invalid server URL: " + e.getMessage();
        }
        return null;
    }

    private long getAppId() throws NumberFormatException {
        return Long.parseLong(this.appId);
    }

    public Optional<String> validateApplication() {
        String appIdError = "Provide positive integer value for Github Application ID. ";
        try {
            if (StringUtils.isEmpty((String)this.appId) || this.getAppId() <= 0L) {
                return Optional.of(appIdError);
            }
        }
        catch (NumberFormatException e) {
            return Optional.of(appIdError + e.getMessage());
        }
        if (StringUtils.isEmpty((String)this.privateKey)) {
            return Optional.of("Provide value for Private Key");
        }
        if (StringUtils.isEmpty((String)this.clientId)) {
            return Optional.of("Provide value for OAuth client ID");
        }
        if (StringUtils.isEmpty((String)this.clientSecret)) {
            return Optional.of("Provide value for OAuth client secret");
        }
        if (this.useForSso && StringUtils.isEmpty((String)this.loginButtonDisplayName)) {
            return Optional.of("Provide value for login button display name");
        }
        return Optional.empty();
    }

    @VisibleForTesting
    boolean isConfiguredInsecurely() {
        return this.useForSso && this.getAllowedOrganizations().isEmpty() && !this.getGroups().isEmpty();
    }

    @Override
    public Optional<String> buildRedirectionLink(URI baseUri, @Nullable String redirectionTarget) {
        if (!this.useForSso || this.validateApplication().isPresent()) {
            return Optional.empty();
        }
        return Optional.of(StringUtils.ensureEndsWith((String)this.serverUrl, (String)"/") + "login/oauth/authorize?client_id=" + this.clientId + "&state=" + new State(this.appId, this.serverUrl, redirectionTarget).toQueryString());
    }

    public String getApiServer() {
        return GitHubUtils.getApiBaseUrl(this.serverUrl);
    }

    public boolean isPublicGitHub() {
        return GitHubUtils.isPublicGitHub(this.serverUrl);
    }

    public List<String> getGroups() {
        if (StringUtils.isEmpty((String)this.groups)) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.groups.split(",")).map(String::trim).filter(group -> !group.isEmpty()).toList();
    }

    public List<String> getAllowedOrganizations() {
        if (StringUtils.isEmpty((String)this.allowedOrganizations)) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.allowedOrganizations.split(",")).map(String::trim).filter(organization -> !organization.isEmpty()).toList();
    }

    @Override
    public String getDisplayName() {
        return this.loginButtonDisplayName;
    }

    @Override
    public ESsoAuthenticatorType getAuthenticatorType() {
        return ESsoAuthenticatorType.GITHUB;
    }

    @Override
    public void integrateExistingOption(IOption existingOption) {
        if (existingOption == null) {
            this.shouldSynchronizeInstallationIndex = true;
            return;
        }
        if (!(existingOption instanceof GitHubApplicationDescription)) {
            return;
        }
        GitHubApplicationDescription existingApplicationDescription = (GitHubApplicationDescription)existingOption;
        if (!this.serverUrl.equals(existingApplicationDescription.serverUrl) || !this.appId.equals(existingApplicationDescription.appId)) {
            this.previousAppId = existingApplicationDescription.appId;
            this.shouldSynchronizeInstallationIndex = true;
        }
    }

    @Override
    public void executedActionsAfterModification(IndexLayer indexLayer) throws StorageException {
        if (!this.shouldSynchronizeInstallationIndex) {
            return;
        }
        LOGGER.debug("Updating GitHub app with ID {} in installation index", (Object)this.previousAppId);
        GitHubInstallationIndex installationIndex = indexLayer.openGlobalIndex(GitHubInstallationIndex.class);
        if (this.previousAppId != null) {
            installationIndex.removeApp(this.previousAppId);
        }
        try {
            GitHubInstallationIndexSynchronizer.performSynchronisationWithAppSpecificClient(installationIndex, new GitHubAppClient(this, indexLayer.openGlobalIndex(AccessTokenIndex.class), LOGGER), LOGGER);
            this.shouldSynchronizeInstallationIndex = false;
        }
        catch (ServiceCallException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Synchronization of GitHub installation index failed for GitHub App {} (id: {}, URL: {})", (Object)this.urlName, (Object)this.appId, (Object)this.serverUrl);
        }
    }

    @Override
    public void executedActionsBeforeDeletion(IndexLayer indexLayer, String optionId) throws StorageException {
        indexLayer.openGlobalIndex(GitHubInstallationIndex.class).removeApp(this.appId);
    }

    private @NonNull App fetchGitHubApp() throws ServiceCallException {
        AccessTokenIndex accessTokenIndex = new AccessTokenIndex((IStore)new InMemoryStore());
        return new GitHubAppClient(this, accessTokenIndex, LogManager.getLogger()).getApp();
    }

    public record State(String appId, String serverUrl, @Nullable String redirectionTarget) {
        public static State fromQueryString(String queryString) throws ConQATException {
            byte[] decoded;
            try {
                decoded = Base64.getDecoder().decode(queryString);
            }
            catch (IllegalArgumentException e) {
                throw new ConQATException("Query string is not base64 encoded: %s".formatted(queryString), (Throwable)e);
            }
            String json = new String(decoded, StandardCharsets.UTF_8);
            return (State)JsonUtils.deserializeFromJson((String)json, State.class);
        }

        public String toQueryString() {
            String json = JsonUtils.serializeToJSON((Object)this);
            String encoded = Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
            return UrlUtils.encodeQueryParameter((String)encoded);
        }
    }
}

