/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public class GitHubUtils {
    public static final String GIT_ACCESS_TOKEN_USERNAME = "x-access-token";
    private static final String URL_SEPARATOR = "/";
    private static final int REPOSITORY_URL_PATH_PARTS = 5;
    private static final Pattern FIRST_SPACE_PATTERN = Pattern.compile(" +");

    public static Optional<Pair<String, String>> getUserAndRepositoryNameFromUrl(String url) {
        String[] urlParts = url.split(URL_SEPARATOR);
        if (urlParts.length != 5) {
            return Optional.empty();
        }
        String username = urlParts[urlParts.length - 2];
        String repositoryName = urlParts[urlParts.length - 1];
        return Optional.of(new Pair((Object)username, (Object)repositoryName));
    }

    static Pair<String, String> parseFullName(String fullName) {
        if (StringUtils.isEmpty((String)fullName)) {
            return new Pair((Object)"", (Object)"");
        }
        String[] parts = FIRST_SPACE_PATTERN.split(fullName = fullName.trim(), 2);
        if (parts.length == 1) {
            return new Pair((Object)fullName, (Object)"");
        }
        return new Pair((Object)parts[0], (Object)parts[1]);
    }

    static boolean areGitHubUrlsEqual(String serverUrl1, String serverUrl2) {
        return Objects.equals(GitHubUtils.normalizeGitHubUrl(serverUrl1), GitHubUtils.normalizeGitHubUrl(serverUrl2));
    }

    private static Object normalizeGitHubUrl(String serverUrl) {
        return StringUtils.stripSuffix((String)serverUrl, (String)URL_SEPARATOR).toLowerCase();
    }

    public static String getApiBaseUrl(String githubUrl) {
        if (GitHubUtils.isPublicGitHub(githubUrl)) {
            return "https://api.github.com/";
        }
        return StringUtils.ensureEndsWith((String)githubUrl, (String)URL_SEPARATOR) + "api/v3/";
    }

    public static boolean isPublicGitHub(String githubUrl) {
        String lowerCaseUrl = githubUrl.toLowerCase();
        return StringUtils.stripSuffix((String)lowerCaseUrl, (String)URL_SEPARATOR).endsWith("github.com");
    }
}

