/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.core.findings.FindingsSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Index(name="findings-schema", options={EStorageOption.COMPRESSED}, valueClasses={FindingTypeDescription.class, FindingsSchema.class})
public class FindingsSchemaIndex
implements IRollbackableIndex,
IProjectIndex {
    public static final String INDEX_NAME = "findings-schema";
    private final Function<CodeScopeName, ValueIndex<FindingTypeDescription>> typeDescriptionDelegate = codeScope -> ValueIndex.forSerializable((IStore)new DelegatingPartitionStore((IStore)new DelegatingPartitionStore(store, "findings-type-description"), codeScope.name()));
    private final SimpleCrudIndex<CodeScopeName, FindingsSchema> schemaDelegate;

    public FindingsSchemaIndex(IStore store) {
        this.schemaDelegate = new SimpleCrudIndex((IStore)new DelegatingPartitionStore(store, INDEX_NAME), ISerializer.of(CodeScopeName::name, CodeScopeName::new).andThen(ISerializer.forString()), ISerializer.forSerializable());
    }

    public void setFindingsSchema(FindingsSchema findingsSchema, CodeScopeName codeScopeName) throws StorageException {
        CCSMAssert.isNotNull((Object)findingsSchema);
        this.schemaDelegate.put((Object)codeScopeName, (Object)findingsSchema);
    }

    @Deprecated
    public @Nullable FindingsSchema getFindingsSchema() throws StorageException {
        return this.getFindingsSchema(CodeScopeAware.DEFAULT_CODE_SCOPE);
    }

    public @Nullable FindingsSchema getFindingsSchema(CodeScopeName codeScopeName) throws StorageException {
        return this.schemaDelegate.get((Object)codeScopeName).orElse(null);
    }

    public CodeScopeAware<FindingsSchema> getFindingSchemasPerCodeScope(SequencedCollection<CodeScopeName> codeScopeNames) throws StorageException {
        List findingsSchemas = this.schemaDelegate.get(codeScopeNames);
        CCSMAssert.isTrue((findingsSchemas.size() == codeScopeNames.size() ? 1 : 0) != 0, (String)"Inconsistent number of schemas");
        LinkedHashMap<CodeScopeName, FindingsSchema> findingsSchemasMap = new LinkedHashMap<CodeScopeName, FindingsSchema>();
        for (Pair pair : CollectionUtils.zip(codeScopeNames, (Iterable)findingsSchemas)) {
            findingsSchemasMap.put((CodeScopeName)pair.getFirst(), (FindingsSchema)pair.getSecond());
        }
        return new CodeScopeAware<Object>(findingsSchemasMap, null);
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) {
    }

    public CodeScopeAware<Map<String, FindingTypeDescription>> getFindingTypeDescriptions(CodeScopeAware<? extends Collection<String>> findingTypeIds) throws StorageException {
        CodeScopeAware<Map<String, FindingTypeDescription>> result = this.getExactFindingTypeDescriptions(findingTypeIds);
        this.patchWithDefaultDescriptions(findingTypeIds, result);
        return result;
    }

    private CodeScopeAware<Map<String, FindingTypeDescription>> getExactFindingTypeDescriptions(CodeScopeAware<? extends Collection<String>> findingTypeIds) throws StorageException {
        CodeScopeAware<Map<String, FindingTypeDescription>> result = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : findingTypeIds.getCodeScopeNames()) {
            List findingTypeIdsList = CollectionUtils.asList(findingTypeIds.getValue(codeScopeName));
            List findingTypeDescriptions = this.typeDescriptionDelegate.apply(codeScopeName).getValues(findingTypeIdsList);
            HashMap<String, FindingTypeDescription> resolvedDescriptions = new HashMap<String, FindingTypeDescription>();
            for (Pair typeAndDescription : CollectionUtils.zip((Iterable)findingTypeIdsList, (Iterable)findingTypeDescriptions)) {
                FindingTypeDescription description = (FindingTypeDescription)typeAndDescription.getSecond();
                if (description == null) continue;
                resolvedDescriptions.put((String)typeAndDescription.getFirst(), description);
            }
            result.setValue(codeScopeName, resolvedDescriptions);
        }
        return result;
    }

    private void patchWithDefaultDescriptions(CodeScopeAware<? extends Collection<String>> findingTypeIds, CodeScopeAware<Map<String, FindingTypeDescription>> result) throws StorageException {
        Map<String, Set<CodeScopeName>> unresolvedDescriptions = FindingsSchemaIndex.determineUnresolvedDescriptions(findingTypeIds, result);
        if (!unresolvedDescriptions.isEmpty()) {
            ArrayList<String> unresolvedTypeIds = new ArrayList<String>(unresolvedDescriptions.keySet());
            List defaultDescriptions = this.typeDescriptionDelegate.apply(CodeScopeAware.DEFAULT_CODE_SCOPE).getValues(unresolvedTypeIds);
            CollectionUtils.forEach(unresolvedTypeIds, (Iterable)defaultDescriptions, (typeId, description) -> {
                for (CodeScopeName codeScope : (Set)unresolvedDescriptions.get(typeId)) {
                    ((Map)result.getValue(codeScope)).put(typeId, description);
                }
            });
        }
    }

    private static Map<String, Set<CodeScopeName>> determineUnresolvedDescriptions(CodeScopeAware<? extends Collection<String>> findingTypeIds, CodeScopeAware<Map<String, FindingTypeDescription>> result) {
        HashMap<String, Set<CodeScopeName>> unresolvedDescriptions = new HashMap<String, Set<CodeScopeName>>();
        for (CodeScopeName codeScopeName : findingTypeIds.getCodeScopeNames()) {
            if (CodeScopeAware.DEFAULT_CODE_SCOPE.equals((Object)codeScopeName)) continue;
            Set<String> resolvedIds = result.getValue(codeScopeName).keySet();
            findingTypeIds.getValue(codeScopeName).stream().filter(Predicate.not(resolvedIds::contains)).forEach(findingTypeId -> unresolvedDescriptions.computeIfAbsent((String)findingTypeId, ignored -> new HashSet()).add(codeScopeName));
        }
        return unresolvedDescriptions;
    }

    public Map<String, FindingTypeDescription> getFindingTypeDescriptions(Collection<String> findingTypeIds, CodeScopeName codeScopeName) throws StorageException {
        return this.getFindingTypeDescriptions(CodeScopeAware.from(codeScopeName, findingTypeIds)).getValue(codeScopeName);
    }

    public PairList<String, FindingTypeDescription> getCodeScopeSpecificFindingTypeDescriptions(CodeScopeName codeScope) throws StorageException {
        return this.typeDescriptionDelegate.apply(codeScope).getAllEntries();
    }

    public CodeScopeAware<Map<String, FindingTypeDescription>> getAllFindingTypeDescriptions(Collection<CodeScopeName> codeScopes) throws StorageException {
        Map defaultValues = this.typeDescriptionDelegate.apply(CodeScopeAware.DEFAULT_CODE_SCOPE).getAllEntries().toMap();
        CodeScopeAware<Map<String, FindingTypeDescription>> result = CodeScopeAware.empty();
        for (CodeScopeName codeScope : codeScopes) {
            if (codeScope.equals((Object)CodeScopeAware.DEFAULT_CODE_SCOPE)) {
                result.setValue(codeScope, defaultValues);
                continue;
            }
            HashMap codeScopeValues = new HashMap(defaultValues);
            codeScopeValues.putAll(this.typeDescriptionDelegate.apply(codeScope).getAllEntries().toMap());
            result.setValue(codeScope, codeScopeValues);
        }
        return result;
    }

    public void setFindingTypeDescription(CodeScopeName codeScope, String typeId, FindingTypeDescription findingTypeDescription) throws StorageException {
        this.typeDescriptionDelegate.apply(codeScope).setValue(typeId, (Object)findingTypeDescription);
    }

    public void setFindingTypeDescriptions(CodeScopeName codeScope, PairList<String, FindingTypeDescription> value) throws StorageException {
        this.typeDescriptionDelegate.apply(codeScope).setValues(value);
    }
}

