/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log;

import com.teamscale.core.log.DetailedLogEntryBase;
import com.teamscale.core.log.LogEntryBase;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.ShortLogEntryBase;
import com.teamscale.core.log.worker.ShortWorkerLog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ResultListCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.jetbrains.annotations.TestOnly;

public abstract class LogIndexBase<SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase>
extends IndexBase
implements IRollbackableIndex {
    private static final byte[] FREQUENCIES_KEY = new byte[]{-1};
    private static final byte[] CUT_OFF_FLAG_KEY = new byte[]{-2};
    private static final String LOCK_NAME = "lock";
    private static final byte[] DETAIL_PARTITION_PREFIX = ByteArrayUtils.longToByteArray((long)4L);

    protected LogIndexBase(IStore store) {
        super(store);
    }

    public int[] getLogLevelFrequencies() throws StorageException {
        byte[] value = this.store.get(FREQUENCIES_KEY);
        if (value == null) {
            return new int[EIndexLogLevel.values().length];
        }
        return (int[])StorageUtils.deserialize((byte[])value);
    }

    public void insertLog(SHORT_LOG_ENTRY shortLog, @Nullable DETAILED_LOG_ENTRY detailedLog) throws StorageException {
        this.insertEntryWithTimeAdjustment(shortLog);
        if (detailedLog != null) {
            ((LogEntryBase)detailedLog).setId(((LogEntryBase)shortLog).getId());
            byte[] key = LogIndexBase.makeKey(DETAIL_PARTITION_PREFIX, ((LogEntryBase)shortLog).getId());
            this.store.put(key, StorageUtils.serialize(detailedLog));
        }
    }

    public static byte[] makeTimestampKey(EIndexLogLevel logLevel, LogEntryIdentifier entryIdentifier) {
        return LogIndexBase.makeTimestampKey(logLevel.storagePrefix, entryIdentifier.timestamp(), entryIdentifier.suffix());
    }

    private static byte[] makeTimestampKey(byte[] keyPrefix, long timestamp, long uniqueSequenceNumber) {
        byte[] part1 = LogIndexBase.makeTimestampKey(keyPrefix, timestamp);
        return ByteArrayUtils.concat((byte[][])new byte[][]{part1, ByteArrayUtils.longToByteArray((long)uniqueSequenceNumber)});
    }

    private static byte[] makeKey(byte[] keyPrefix, LogEntryIdentifier entryIdentifier) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{keyPrefix, ByteArrayUtils.longToByteArray((long)entryIdentifier.timestamp()), ByteArrayUtils.longToByteArray((long)entryIdentifier.suffix())});
    }

    private static byte[] makeTimestampKey(byte[] keyPrefix, long timestamp) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{keyPrefix, ByteArrayUtils.longToByteArray((long)timestamp)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertEntryWithTimeAdjustment(SHORT_LOG_ENTRY shortLog) throws StorageException {
        Lock lock = this.store.obtainLock(LOCK_NAME);
        lock.lock();
        try {
            ((LogEntryBase)shortLog).setId(((LogEntryBase)shortLog).getId().withSuffix(LogEntryIdentifier.freshLogEntrySuffix()));
            EIndexLogLevel level = EIndexLogLevel.fromLogEntry(shortLog);
            int[] frequencies = this.getLogLevelFrequencies();
            int n = level.ordinal();
            frequencies[n] = frequencies[n] + 1;
            PairList values = PairList.from((Object)LogIndexBase.makeKey(level.storagePrefix, ((LogEntryBase)shortLog).getId()), (Object)StorageUtils.serialize(shortLog));
            values.add((Object)FREQUENCIES_KEY, (Object)StorageUtils.serialize((Serializable)frequencies));
            this.store.put(values);
        }
        finally {
            lock.unlock();
        }
    }

    public DETAILED_LOG_ENTRY getDetailedLog(LogEntryIdentifier logEntryIdentifier) throws StorageException {
        byte[] bytes = this.store.get(LogIndexBase.makeTimestampKey(DETAIL_PARTITION_PREFIX, logEntryIdentifier.timestamp(), logEntryIdentifier.suffix()));
        return (DETAILED_LOG_ENTRY)((DetailedLogEntryBase)StorageUtils.deserialize((byte[])bytes));
    }

    @Deprecated
    @TestOnly
    public DETAILED_LOG_ENTRY getDetailedLog(long timestamp) throws StorageException {
        PairList result = this.store.getEntriesStartingWith(LogIndexBase.makeTimestampKey(DETAIL_PARTITION_PREFIX, timestamp));
        if (result.size() == 1) {
            return (DETAILED_LOG_ENTRY)((DetailedLogEntryBase)StorageUtils.deserialize((byte[])((byte[])result.getSecond(0))));
        }
        if (result.size() > 1) {
            throw new StorageException("More than one entry found for the given timestamp. Please query by providing the ID, too.");
        }
        return null;
    }

    public List<SHORT_LOG_ENTRY> getShortLogs(List<Long> timestamps) throws StorageException {
        return CollectionUtils.mapWithException(timestamps, this::getFirstMatchingShortLogEntry);
    }

    private SHORT_LOG_ENTRY getFirstMatchingShortLogEntry(Long timestamp) throws StorageException {
        List keysToCheck = CollectionUtils.map((Object[])EIndexLogLevel.values(), level -> LogIndexBase.makeTimestampKey(level.storagePrefix, timestamp));
        for (byte[] key : keysToCheck) {
            PairList entriesForKey = this.store.getEntriesStartingWith(List.of(key), storedKey -> storedKey, StorageUtils::deserialize);
            if (entriesForKey.isEmpty()) continue;
            entriesForKey.getSecond(0);
        }
        return null;
    }

    public List<SHORT_LOG_ENTRY> getEntries(EIndexLogLevel level, long startTimestamp, long endTimestamp) throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        byte[] startKey = LogIndexBase.makeTimestampKey(level.storagePrefix, startTimestamp);
        byte[] endKey = LogIndexBase.makeTimestampKey(level.storagePrefix, endTimestamp);
        this.store.scan(startKey, endKey, (IKeyValueCallback)callback);
        List result = callback.getResultOrThrowException();
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(List<byte[]> keys) throws StorageException {
        Lock lock = this.store.obtainLock(LOCK_NAME);
        lock.lock();
        try {
            this.purge(keys, 0);
            int[] newFrequencies = new int[ELogLevel.values().length];
            for (EIndexLogLevel level : EIndexLogLevel.values()) {
                newFrequencies[level.ordinal()] = StorageUtils.listKeysStartingWith((byte[])level.storagePrefix, (IStore)this.store).size();
            }
            this.store.put(FREQUENCIES_KEY, StorageUtils.serialize((Serializable)newFrequencies));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(int retainCount) throws StorageException {
        Lock lock = this.store.obtainLock(LOCK_NAME);
        lock.lock();
        try {
            int[] newFrequencies = new int[ELogLevel.values().length];
            for (EIndexLogLevel level : EIndexLogLevel.values()) {
                newFrequencies[level.ordinal()] = this.purge(StorageUtils.listKeysStartingWith((byte[])level.storagePrefix, (IStore)this.store), retainCount);
            }
            this.store.put(FREQUENCIES_KEY, StorageUtils.serialize((Serializable)newFrequencies));
        }
        finally {
            lock.unlock();
        }
    }

    private int purge(List<byte[]> keys, int threshold) throws StorageException {
        if (keys.size() <= threshold) {
            return keys.size();
        }
        List<byte[]> shortEntryKeysToRemove = keys.subList(0, keys.size() - threshold);
        ArrayList<byte[]> keysToRemove = new ArrayList<byte[]>(shortEntryKeysToRemove);
        for (byte[] key : shortEntryKeysToRemove) {
            byte[] detailEntryKey = LogIndexBase.makeTimestampKey(DETAIL_PARTITION_PREFIX, LogIndexBase.getTimestampFromKey(key), LogIndexBase.getIdSuffixFromKey(key));
            keysToRemove.add(detailEntryKey);
        }
        this.store.remove(keysToRemove);
        if (!keysToRemove.isEmpty()) {
            this.store.put(CUT_OFF_FLAG_KEY, ByteArrayUtils.intToByteArray((int)1));
        }
        return threshold;
    }

    private static long getTimestampFromKey(byte[] key) {
        int startIndex = key.length - 16;
        int endIndexExclusive = startIndex + 8;
        byte[] timestampPart = Arrays.copyOfRange(key, startIndex, endIndexExclusive);
        return ByteArrayUtils.byteArrayToLong((byte[])timestampPart);
    }

    private static long getIdSuffixFromKey(byte[] key) {
        byte[] idSuffixPart = Arrays.copyOfRange(key, key.length - 8, key.length);
        return ByteArrayUtils.byteArrayToLong((byte[])idSuffixPart);
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) {
    }

    public boolean hasBeenTruncated() throws StorageException {
        return this.store.get(CUT_OFF_FLAG_KEY) != null;
    }

    public static enum EIndexLogLevel {
        INFO(1),
        WARN(2),
        ERROR(3),
        FATAL(4),
        DEBUG(5);

        private final byte[] storagePrefix;

        private EIndexLogLevel(int prefixValue) {
            this.storagePrefix = new byte[]{(byte)prefixValue};
        }

        public static EIndexLogLevel fromLogEntry(ShortLogEntryBase entry) {
            ShortWorkerLog shortWorkerLog;
            if (entry instanceof ShortWorkerLog && (shortWorkerLog = (ShortWorkerLog)entry).hasFailed()) {
                return FATAL;
            }
            if (entry.getFatalCount() > 0) {
                return FATAL;
            }
            if (entry.getErrorCount() > 0) {
                return ERROR;
            }
            if (entry.getWarningCount() > 0) {
                return WARN;
            }
            return INFO;
        }
    }
}

