/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.option;

import com.teamscale.commons.annotation.ClassIndexUtils;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionDescriptor;
import com.teamscale.core.option.OptionIndexBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public abstract class OptionRegistryBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CATEGORY_SEPARATOR = ":";
    public static final String OPTION_SELECTOR_SEPARATOR = "/";
    private final Map<String, OptionDescriptor> optionDescriptors = new HashMap<String, OptionDescriptor>();

    protected OptionRegistryBase(EOptionType optionType) {
        this.discoverOptions(optionType);
    }

    public void registerOptionDescriptor(String optionId, String optionReadableName, Class<? extends IOption> optionClass, boolean multiOption, boolean hidden) {
        CCSMAssert.isFalse((boolean)optionId.contains(OPTION_SELECTOR_SEPARATOR), (String)"Option id may not contain the separator!");
        CCSMAssert.isFalse((boolean)this.optionDescriptors.containsKey(optionId), (String)("Registered duplicate option for id " + optionId));
        this.optionDescriptors.put(optionId, new OptionDescriptor(optionId, optionReadableName, optionClass, multiOption, hidden));
    }

    private void discoverOptions(EOptionType optionType) {
        List optionClasses = ClassIndexUtils.getAnnotated(Option.class);
        for (Class optionClass : optionClasses) {
            Option optionAnnotation = optionClass.getAnnotation(Option.class);
            if (!IOption.class.isAssignableFrom(optionClass)) {
                LOGGER.error("Expected {} to be an instance of {}", (Object)optionClass, IOption.class);
                continue;
            }
            if (optionType != optionAnnotation.type()) continue;
            boolean hidden = optionAnnotation.hidden();
            if (optionAnnotation.visibilityFeatureToggle() != EFeatureToggle.NONE) {
                hidden = !optionAnnotation.visibilityFeatureToggle().isEnabled();
            }
            this.registerOptionDescriptor(optionAnnotation.id(), optionAnnotation.name(), optionClass.asSubclass(IOption.class), optionAnnotation.multiOption(), hidden);
        }
    }

    public void unregisterOptionDescriptor(String optionId) {
        this.optionDescriptors.remove(optionId);
    }

    public List<OptionDescriptor> getOptionDescriptors() {
        return this.optionDescriptors.values().stream().filter(Predicate.not(this::isOverridden)).toList();
    }

    protected boolean isOverridden(OptionDescriptor optionDescriptor) {
        return false;
    }

    public final boolean isOverridden(String optionId) {
        OptionDescriptor optionDescriptor = this.getOptionDescriptor(optionId);
        if (optionDescriptor == null) {
            throw new IllegalArgumentException("No option found for: " + optionId);
        }
        return this.isOverridden(optionDescriptor);
    }

    public <T extends IOption> void putOption(String optionCategory, String optionId, String multiOptionSelector, T value, OptionIndexBase index) throws StorageException {
        this.putOption(optionCategory, optionId, multiOptionSelector, value, false, index);
    }

    public <T extends IOption> void putOption(String optionCategory, String optionId, String multiOptionSelector, T value, boolean force, OptionIndexBase index) throws StorageException {
        OptionDescriptor option = this.getOptionDescriptor(optionId);
        CCSMAssert.isTrue((option != null ? 1 : 0) != 0, (String)("No option descriptor found: " + optionId));
        if (!force && this.isOverridden(option)) {
            throw new StorageException("Attempting to store a value that is overridden and can not be changed at runtime: " + optionId);
        }
        if (option.isMultiple()) {
            CCSMAssert.isTrue((multiOptionSelector != null ? 1 : 0) != 0, (String)"Selector not given for multi option.");
        } else {
            CCSMAssert.isTrue((multiOptionSelector == null ? 1 : 0) != 0, (String)"Selector given for non-multi option.");
        }
        String key = OptionRegistryBase.getStorageKey(optionCategory, optionId, multiOptionSelector);
        index.setOption(key, value);
    }

    private static String getStorageKey(String optionCategory, String optionId, String multiOptionSelector) {
        String key = optionCategory + CATEGORY_SEPARATOR + optionId;
        if (multiOptionSelector != null) {
            key = key + OPTION_SELECTOR_SEPARATOR + multiOptionSelector;
        }
        return key;
    }

    public Map<String, IOption> getOptions(String optionCategory, OptionIndexBase index) throws StorageException {
        return this.getOptions(optionCategory, index, true);
    }

    protected Map<String, IOption> getOptions(String optionPrefix, OptionIndexBase index, boolean addOptionPrefixSeparator) throws StorageException {
        if (addOptionPrefixSeparator) {
            optionPrefix = (String)optionPrefix + CATEGORY_SEPARATOR;
        }
        PairList<String, IOption> optionList = index.getOptionsStartingWith((String)optionPrefix);
        this.appendDirectOptions((String)optionPrefix, optionList);
        HashMap<String, IOption> options = new HashMap<String, IOption>();
        for (int i = 0; i < optionList.size(); ++i) {
            String key = StringUtils.stripPrefix((String)((String)optionList.getFirst(i)), (String)optionPrefix);
            options.put(key, (IOption)optionList.getSecond(i));
        }
        for (Map.Entry<String, OptionDescriptor> entry : this.optionDescriptors.entrySet()) {
            if (options.containsKey(entry.getKey()) || this.isOverridden(entry.getValue())) continue;
            options.put(entry.getKey(), OptionRegistryBase.createDefaultValue(this.optionDescriptors.get(entry.getKey()).getOptionClass()));
        }
        return options;
    }

    protected void appendDirectOptions(String optionPrefix, PairList<String, IOption> optionList) {
    }

    private static <T extends IOption> T createDefaultValue(Class<T> optionClass) {
        try {
            return (T)((IOption)optionClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Could not create default option: " + e.getMessage()));
        }
    }

    public <T extends IOption> @Nullable T getOption(String optionCategory, String optionId, String multiOptionSelector, Class<T> expectedClass, OptionIndexBase index) throws StorageException {
        OptionDescriptor option = this.getOptionDescriptor(optionId);
        if (option == null) {
            return null;
        }
        CCSMAssert.isTrue((boolean)expectedClass.isAssignableFrom(option.getOptionClass()), (String)"Invalid class used to access option!");
        if (option.isMultiple() == (multiOptionSelector == null)) {
            return null;
        }
        IOption optionValue = this.getOptionValueOverride(optionCategory, optionId, multiOptionSelector);
        if (option.getOptionClass().isInstance(optionValue)) {
            return (T)optionValue;
        }
        optionValue = index.getOption(OptionRegistryBase.getStorageKey(optionCategory, optionId, multiOptionSelector));
        if (option.getOptionClass().isInstance(optionValue)) {
            return (T)optionValue;
        }
        return OptionRegistryBase.createDefaultValue(expectedClass);
    }

    protected @Nullable IOption getOptionValueOverride(String optionCategory, String optionId, String multiOptionSelector) {
        return null;
    }

    public static boolean containsOptionValue(String optionCategory, String optionId, String multiOptionSelector, OptionIndexBase index) throws StorageException {
        return index.getOption(OptionRegistryBase.getStorageKey(optionCategory, optionId, multiOptionSelector)) != null;
    }

    public OptionDescriptor getOptionDescriptor(String optionId) {
        return this.optionDescriptors.get(optionId);
    }

    public static void removeOption(String optionCategory, String optionId, String multiOptionSelector, OptionIndexBase index) throws StorageException {
        index.removeOption(OptionRegistryBase.getStorageKey(optionCategory, optionId, multiOptionSelector));
    }

    public static Pair<String, String> extractOptionNameAndSelector(String optionId) {
        if (optionId.contains(OPTION_SELECTOR_SEPARATOR)) {
            String[] parts = optionId.split(OPTION_SELECTOR_SEPARATOR, 2);
            return new Pair((Object)parts[0], (Object)parts[1]);
        }
        return new Pair((Object)optionId, null);
    }
}

