/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.option;

import com.teamscale.core.option.HashedPasswordOption;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionDescriptor;
import com.teamscale.core.option.PasswordOption;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class PasswordOptionUtils {
    public static final String PASSWORD_MASK = "#PW_PLACEHOLDER#";

    private static List<Field> getPasswordFields(IOption option) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : OptionDescriptor.getOptionFields(option.getClass())) {
            if (!field.isAnnotationPresent(PasswordOption.class) && !field.isAnnotationPresent(HashedPasswordOption.class)) continue;
            result.add(field);
        }
        return result;
    }

    public static void unmaskPasswords(IOption option, IOption existingOption) {
        if (existingOption == null) {
            return;
        }
        CCSMAssert.isTrue((option.getClass() == existingOption.getClass() ? 1 : 0) != 0, (String)"New and existing options have different class!");
        try {
            for (Field field : PasswordOptionUtils.getPasswordFields(option)) {
                Object value = field.get(option);
                if (!PASSWORD_MASK.equals(value)) continue;
                field.set(option, field.get(existingOption));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            CCSMAssert.fail((String)"This is not possible as we checked access before!");
        }
    }
}

