/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.user;

import com.teamscale.core.authenticate.AuthenticationRequestHandler;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class UserGroupUtils {
    private static final String SERVICE_NAME = "debug-user-group-mapping";
    private static final Logger LOGGER = LogManager.getLogger();

    private static void logErrorMessage(String message) {
        LOGGER.error(message + ". Consider using the service debug-user-group-mapping to fix the inconsistencies.");
    }

    public static void removeFromAllGroups(User user, UserGroupIndex groupIndex, IMessageBroker messageBroker) throws StorageException {
        ArrayList<String> groupIds = new ArrayList<String>(user.getGroupIds());
        List<UserGroup> groups = groupIndex.getUserGroups(groupIds);
        ArrayList<UserGroup> groupsToPersist = new ArrayList<UserGroup>();
        for (int i = 0; i < groups.size(); ++i) {
            UserGroup group = groups.get(i);
            if (group != null) {
                group.removeUser(user);
                groupsToPersist.add(group);
                continue;
            }
            UserGroupUtils.logErrorMessage("Group " + (String)groupIds.get(i) + " not found in group index when removing user " + String.valueOf(user) + " from all groups");
        }
        groupIndex.setGroups(groupsToPersist);
        user.setGroupIds(new HashSet<String>());
        UserGroupUtils.invalidateCaches(messageBroker);
    }

    public static void updateGroupMembership(UserGroup existingGroup, UserGroup newGroup, UserIndex userIndex, UserGroupIndex groupIndex, IMessageBroker messageBroker) throws StorageException {
        UnmodifiableSet<String> oldUserNames = existingGroup.getUserNames();
        UnmodifiableSet<String> newUserNames = newGroup.getUserNames();
        ArrayList<User> usersToPersist = new ArrayList<User>();
        List<User> removedUsers = UserGroupUtils.getExistingUsers(userIndex, CollectionUtils.subtract(oldUserNames, newUserNames), userName -> "User " + userName + " not found when renaming " + existingGroup.getName() + " to group " + newGroup.getName() + " and updating group memberships");
        for (User user : removedUsers) {
            user.removeGroup(existingGroup);
            usersToPersist.add(user);
        }
        Set addedUsers = CollectionUtils.subtract(newUserNames, oldUserNames);
        UserGroupUtils.addToGroup(newGroup, addedUsers, userIndex, groupIndex, messageBroker);
        if (!existingGroup.getName().equals(newGroup.getName())) {
            List<User> keptUsers = UserGroupUtils.getExistingUsers(userIndex, CollectionUtils.intersectionSet(newUserNames, (Collection[])new Collection[]{oldUserNames}), userName -> "User " + userName + " not found when updating users for existing group " + existingGroup.getName() + " and new group " + newGroup.getName());
            for (User user : keptUsers) {
                user.removeGroup(existingGroup);
                user.addGroup(newGroup);
                usersToPersist.add(user);
            }
        }
        userIndex.setUsers(usersToPersist, messageBroker);
        UserGroupUtils.invalidateCaches(messageBroker);
    }

    private static List<User> getExistingUsers(UserIndex userIndex, Set<String> userNames, Function<String, String> userNotFoundMessageCreator) throws StorageException {
        ArrayList<User> result = new ArrayList<User>();
        ArrayList<String> userNamesOrdered = new ArrayList<String>(userNames);
        List<User> users = userIndex.getUsers(userNamesOrdered);
        for (int i = 0; i < users.size(); ++i) {
            if (users.get(i) != null) {
                result.add(users.get(i));
                continue;
            }
            UserGroupUtils.logErrorMessage(userNotFoundMessageCreator.apply((String)userNamesOrdered.get(i)));
        }
        return result;
    }

    public static void removeAllUsersFromGroup(UserGroup group, UserIndex userIndex, UserGroupIndex groupIndex, IMessageBroker messageBroker) throws StorageException {
        List<User> users = UserGroupUtils.getExistingUsers(userIndex, group.getUserNames(), userName -> "User " + userName + " not found when removing all users from group " + group.getName());
        ArrayList<User> usersToPersist = new ArrayList<User>();
        for (User user : users) {
            user.removeGroup(group);
            Set<String> groupIds = user.getGroupIds();
            groupIds.remove(group.getSubjectId());
            user.setGroupIds(groupIds);
            usersToPersist.add(user);
        }
        group.setUserNames(Collections.emptySet());
        groupIndex.setGroup(group);
        userIndex.setUsers(usersToPersist, messageBroker);
        UserGroupUtils.invalidateCaches(messageBroker);
    }

    public static void addToGroup(UserGroup group, Set<String> userNames, UserIndex userIndex, UserGroupIndex groupIndex, IMessageBroker messageBroker) throws StorageException {
        List<User> users = UserGroupUtils.getExistingUsers(userIndex, userNames, userName -> "User " + userName + " not found when adding user to group " + group.getName());
        ArrayList<User> usersToPersist = new ArrayList<User>();
        for (User user : users) {
            user.addGroup(group);
            user.addGroupIds(Collections.singleton(group.getSubjectId()));
            usersToPersist.add(user);
            group.addUser(user);
        }
        groupIndex.setGroup(group);
        userIndex.setUsers(usersToPersist, messageBroker);
    }

    public static void invalidateCaches(IMessageBroker messageBroker) {
        AuthenticationRequestHandler.clearAccessTokenCache(messageBroker);
    }

    public static UserGroup getOrCreateUserGroup(GlobalStorageSystem globalStorageSystem, String userGroupName) throws StorageException {
        UserGroupIndex groupIndex = (UserGroupIndex)globalStorageSystem.openGlobalIndex(UserGroupIndex.class);
        UserGroup group = groupIndex.getUserGroup(userGroupName);
        if (group == null) {
            group = new UserGroup(userGroupName);
            groupIndex.setGroup(group);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUserToGroups(User user, List<String> groupNames, UserGroupIndex groupIndex) throws StorageException {
        if (groupNames.isEmpty()) {
            return;
        }
        Lock lock = groupIndex.getUpdateLock();
        lock.lock();
        try {
            List<UserGroup> groups = groupIndex.getUserGroups(groupNames);
            for (int i = 0; i < groups.size(); ++i) {
                UserGroup group = groups.get(i);
                if (group == null) {
                    LOGGER.warn("Failed to add " + user.getUsername() + " to group! The group " + groupNames.get(i) + " does not exist!");
                    continue;
                }
                user.addGroup(group);
                group.addUser(user);
            }
            groupIndex.setGroups(CollectionUtils.filter(groups, Objects::nonNull));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUserFromGroups(User user, List<String> groupNames, UserGroupIndex groupIndex) throws StorageException {
        if (groupNames.isEmpty()) {
            return;
        }
        Lock lock = groupIndex.getUpdateLock();
        lock.lock();
        try {
            List<UserGroup> groups = groupIndex.getUserGroups(groupNames);
            for (int i = 0; i < groups.size(); ++i) {
                UserGroup group = groups.get(i);
                if (group == null) {
                    user.removeGroupByName(groupNames.get(i));
                    continue;
                }
                user.removeGroup(group);
                group.removeUser(user);
            }
            groupIndex.setGroups(CollectionUtils.filter(groups, Objects::nonNull));
        }
        finally {
            lock.unlock();
        }
    }
}

