/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.user;

import com.teamscale.core.user.EUserActivityPeriods;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="user-last-activity", options={EStorageOption.BACKUP}, valueClasses={Long.class})
public class UserLastActivityIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "user-last-activity";
    private static final Logger LOGGER = LogManager.getLogger();
    private final ConvenientStore delegate;
    private static final String USER_FILTER_PROPERTY_NAME = "com.teamscale.user-activity.filter";
    private static final List<Pattern> USER_FILTER_PATTERNS;

    public UserLastActivityIndex(IStore store) {
        this.delegate = new ConvenientStore(store);
    }

    public List<Long> getLastActivityTimestamps() throws StorageException {
        List encodedTimestamps = StorageUtils.listStringKeysAndValues((IStore)this.delegate).filter((username, _unused) -> this.includeUsername((String)username)).extractSecondList();
        return CollectionUtils.map((Collection)encodedTimestamps, ByteArrayUtils::byteArrayToLong);
    }

    private boolean includeUsername(String username) {
        for (Pattern pattern : USER_FILTER_PATTERNS) {
            if (!pattern.matcher(username).matches()) continue;
            return false;
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<@Nullable Long> getLastActivityTimestampForUsers(List<String> usernames) throws StorageException {
        @Nullable List result = CollectionUtils.map((Collection)this.delegate.getWithStrings(usernames), bytes -> {
            if (bytes == null) {
                return null;
            }
            return ByteArrayUtils.byteArrayToLong((byte[])bytes);
        });
        for (int i = 0; i < usernames.size(); ++i) {
            if (this.includeUsername(usernames.get(i))) continue;
            result.set(i, null);
        }
        return result;
    }

    public void setLastActivity(PairList<String, Long> usernamesAndLastActivity) throws StorageException {
        this.delegate.putWithStrings(usernamesAndLastActivity.mapSecond(ByteArrayUtils::longToByteArray));
    }

    public void setNumberOfCommitters(EUserActivityPeriods activityPeriod, long numberOfCommitters) throws StorageException {
        this.delegate.putWithString(UserLastActivityIndex.createKey(activityPeriod), ByteArrayUtils.longToByteArray((long)numberOfCommitters));
    }

    public int getNumberOfCommitters(EUserActivityPeriods activityPeriod) throws StorageException {
        byte[] result = this.delegate.getWithString(UserLastActivityIndex.createKey(activityPeriod));
        if (result == null) {
            return 0;
        }
        long numberOfCommitters = ByteArrayUtils.byteArrayToLong((byte[])result);
        return Math.toIntExact(numberOfCommitters);
    }

    private static String createKey(EUserActivityPeriods activityPeriods) {
        return "###" + activityPeriods.toString() + "###";
    }

    static {
        String[] userFilters = System.getProperty(USER_FILTER_PROPERTY_NAME, "").split(",");
        List userFilterPatterns = List.of();
        try {
            userFilterPatterns = CollectionUtils.filterAndMap(Arrays.asList(userFilters), s -> !s.isEmpty(), Pattern::compile);
        }
        catch (PatternSyntaxException e) {
            LOGGER.error("Failed to compile patterns '" + System.getProperty(USER_FILTER_PROPERTY_NAME, "") + "'. User activity filter will be disabled. Message: " + e.getMessage(), (Throwable)e);
        }
        userFilterPatterns.add(Pattern.compile("prometheus-monitoring-internal-teamscale-user"));
        USER_FILTER_PATTERNS = userFilterPatterns;
    }
}

