/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import com.teamscale.core.index.CommitDescriptorIndex;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

public class CommitDescriptorUtils {
    public static Optional<ParentedCommitDescriptor> guessCorrespondingCodeCommit(CommitDescriptor nonCodeCommit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        long guessedCodeCommitTimestamp = CommitDescriptorUtils.floorToSecond(nonCodeCommit);
        CommitDescriptor potentialCodeCommitDescriptor = new CommitDescriptor(nonCodeCommit.getBranchName(), guessedCodeCommitTimestamp);
        Optional<ParentedCommitDescriptor> commit = Optional.ofNullable(commitDescriptorIndex.getCommit(potentialCodeCommitDescriptor));
        if (commit.isPresent()) {
            return Optional.of(CommitDescriptorUtils.findLatestSuccessorOnBranch(commit.get(), commitDescriptorIndex));
        }
        return commit;
    }

    private static ParentedCommitDescriptor findLatestSuccessorOnBranch(ParentedCommitDescriptor commit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        ParentedCommitDescriptor latestKnownExistingCommit = commit;
        ParentedCommitDescriptor successorCandidateCommit = commitDescriptorIndex.getCommit(latestKnownExistingCommit.cloneWithIncrementedTimestamp());
        while (successorCandidateCommit != null) {
            latestKnownExistingCommit = successorCandidateCommit;
            successorCandidateCommit = commitDescriptorIndex.getCommit(latestKnownExistingCommit.cloneWithIncrementedTimestamp());
        }
        return latestKnownExistingCommit;
    }

    private static long floorToSecond(CommitDescriptor nonCodeCommit) {
        return nonCodeCommit.getTimestamp() - nonCodeCommit.getTimestamp() % 1000L;
    }
}

