/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import com.teamscale.core.index.CommitDescriptorIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.BranchCommitReadingStore;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class HistoryUtils {
    public static List<ParentedCommitDescriptor> extractCommitDescriptorsFromRawBranchedStore(IBranchingLayer branchingLayer) throws StorageException {
        List commitInfos = branchingLayer.getCommitInfos();
        return CollectionUtils.sort((Collection)CollectionUtils.map((Collection)commitInfos, HistoryUtils::convertToCommitDescriptor));
    }

    public static List<ParentedCommitDescriptor> extractCommitDescriptorsFromRawBranchedStore(IBranchingLayer branchingLayer, String branch) throws StorageException {
        List commitInfos = branchingLayer.getCommitInfosForBranch(branch);
        return CollectionUtils.sort((Collection)CollectionUtils.map((Collection)commitInfos, HistoryUtils::convertToCommitDescriptor));
    }

    public static ParentedCommitDescriptor resolveParentedCommit(IBranchingLayer branchingLayer, CommitDescriptor commit) throws StorageException {
        IBranchCommitInfo commitInfo = branchingLayer.readCommit(commit.getBranchName(), commit.getTimestamp());
        if (commitInfo == null) {
            return null;
        }
        return HistoryUtils.convertToCommitDescriptor(commitInfo);
    }

    private static ParentedCommitDescriptor convertToCommitDescriptor(IBranchCommitInfo commitInfo) {
        CommitDescriptor commitDescriptor = new CommitDescriptor(commitInfo.getBranchName(), commitInfo.getTimestamp());
        Pair parentCommitBranchAndTimestamp = commitInfo.getParentCommitBranchAndTimestamp();
        if (parentCommitBranchAndTimestamp == null) {
            return new ParentedCommitDescriptor(commitDescriptor, Collections.emptyList());
        }
        CommitDescriptor parentCommitDescriptor = new CommitDescriptor((String)parentCommitBranchAndTimestamp.getFirst(), ((Long)parentCommitBranchAndTimestamp.getSecond()).longValue());
        return new ParentedCommitDescriptor(commitDescriptor, List.of(parentCommitDescriptor));
    }

    public static <ValueType extends Serializable> List<ValueType> getEntryHistory(String key, CommitDescriptor startCommit, long lowestTimestampBoundary, CommitDescriptorIndex commitDescriptorIndex, IBranchingLayer branchingLayer) throws StorageException {
        CCSMAssert.isTrue((startCommit.getTimestamp() > lowestTimestampBoundary ? 1 : 0) != 0, (String)"The startCommits timestamp must be bigger than the lowestTimestampBoundary (in order to search from new to old).");
        Optional<CommitDescriptor> actualStartCommit = commitDescriptorIndex.getFirstActualCommitBeforeOrAt(startCommit, lowestTimestampBoundary);
        if (actualStartCommit.isEmpty()) {
            return new ArrayList();
        }
        List<ParentedCommitDescriptor> historicalCommits = commitDescriptorIndex.getCommitHistoryWithFirstParentCommits(actualStartCommit.get(), lowestTimestampBoundary);
        return HistoryUtils.extractValueTypesFromHistoricalCommits(historicalCommits, key, branchingLayer);
    }

    private static <ValueType extends Serializable> List<ValueType> extractValueTypesFromHistoricalCommits(List<ParentedCommitDescriptor> historicalCommits, String key, IBranchingLayer branchingLayer) throws StorageException {
        ArrayList extractedTypes = new ArrayList();
        if (historicalCommits.isEmpty()) {
            return extractedTypes;
        }
        byte[] binaryKey = StringUtils.stringToBytes((String)key);
        PairList branchNamesAndValues = new PairList(historicalCommits.size());
        for (int i = 0; i < historicalCommits.size() - 1; ++i) {
            CommitDescriptor commit = (CommitDescriptor)historicalCommits.get(i);
            branchNamesAndValues.add((Object)commit.getBranchName(), (Object)commit.getTimestamp());
        }
        byte[] oldRawValue = null;
        for (byte[] rawValue : branchingLayer.getValues(branchNamesAndValues, binaryKey)) {
            if (rawValue == null) continue;
            if (BranchCommitReadingStore.isTombStone((byte[])rawValue)) {
                return extractedTypes;
            }
            if (oldRawValue != null && Arrays.equals(oldRawValue, rawValue)) continue;
            oldRawValue = rawValue;
            HistoryUtils.convertAndAppend(rawValue, extractedTypes);
        }
        HistoryUtils.handleLastCommit(historicalCommits, branchingLayer, extractedTypes, binaryKey, oldRawValue);
        return extractedTypes;
    }

    private static <ValueType extends Serializable> void handleLastCommit(List<ParentedCommitDescriptor> historicalCommits, IBranchingLayer branchingLayer, List<ValueType> extractedTypes, byte[] binaryKey, byte[] oldRawValue) throws StorageException {
        CommitDescriptor lastCommit = (CommitDescriptor)CollectionUtils.getLast(historicalCommits);
        if (!branchingLayer.commitExists(lastCommit.getBranchName(), lastCommit.getTimestamp())) {
            return;
        }
        IStore store = branchingLayer.openStore(HistoryAccessOption.readTimestamp((String)lastCommit.getBranchName(), (long)lastCommit.getTimestamp()));
        byte[] lastValue = store.get(binaryKey);
        if (!(lastValue == null || oldRawValue != null && Arrays.equals(oldRawValue, lastValue))) {
            HistoryUtils.convertAndAppend(lastValue, extractedTypes);
        }
    }

    private static <ValueType extends Serializable> void convertAndAppend(byte[] binaryValue, List<ValueType> extractedTypes) throws StorageException {
        Serializable value = StorageUtils.deserialize((byte[])binaryValue);
        if (value != null) {
            extractedTypes.add(value);
        }
    }
}

